#include <qvbox.h>
#include <qlabel.h>
#include <qvbuttongroup.h>
#include <qhbuttongroup.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <callaudio.h>
#include <kglobal.h>
#include <kconfig.h>
#include <dspoutoss.h>
#include <audiocontrol.h>

AudioControl::AudioControl( CallAudio *callaudio, QWidget *parent, const char *name )
	: KDialogBase( parent, name, false, QString( name ) + "Audio Properties", Ok|Apply|Cancel, Ok, true )
{
	a = callaudio;
	QVBox *vbox = makeVBoxMainWidget();
	(void) new QLabel( "Use OSS Device:", vbox );
	dspdev = new QLineEdit( a->getOSSFilename(), vbox );
	dspdev->setMinimumWidth( fontMetrics().maxWidth() * 20 );
	dspdev->setText( a->getOSSFilename() );
	bg1 = new QHButtonGroup( "Preferred Codec", vbox );
	QRadioButton *ulawButton = new QRadioButton( "G711u", bg1 );
	bg1->insert( ulawButton, ulaw );
	QRadioButton *gsmButton = new QRadioButton( "GSM", bg1 );
	bg1->insert( gsmButton, gsm );
	QRadioButton *ilbcButton = new QRadioButton( "iLBC", bg1 );
	bg1->insert( ilbcButton, ilbc );

	// Size of Fragment
	bg2 = new QHButtonGroup( "Size of Fragment", vbox );
	QRadioButton *s16 = new QRadioButton( "16", bg2 );
	bg2->insert( s16, size16 );
	QRadioButton *s32 = new QRadioButton( "32", bg2 );
	bg2->insert( s32, size32 );
	QRadioButton *s64 = new QRadioButton( "64", bg2 );
	bg2->insert( s64, size64 );
	QRadioButton *s128 = new QRadioButton( "128", bg2 );
	bg2->insert( s128, size128 );
	QRadioButton *s256 = new QRadioButton( "256", bg2 );
	bg2->insert( s256, size256 );

	// Size of Payload
	bg3 = new QHButtonGroup( "Size of Payload", vbox );
	QRadioButton *s80 = new QRadioButton( "80 (10 ms Sample)", bg3 );
	bg3->insert( s80, size80 );
	QRadioButton *s160 = new QRadioButton( "160 (20 ms Sample)", bg3 );
	bg3->insert( s160, size32 );

	KConfig *config = KGlobal::config();
	config->setGroup( "Audio" );
	QString codec = config->readEntry( "Codec", "ULAW" );
	if( codec == "ULAW" ) {
		ulawButton->setChecked(TRUE);
	} else if( codec == "GSM" ) {
		gsmButton->setChecked(TRUE);
	} else if( codec == "ILBC" ) {
		ilbcButton->setChecked(TRUE);
	}
	config->setGroup( "DSP" );
	switch( config->readNumEntry( "SizeOfFragment", 7 ) ) {
		case 4:
			s16->setChecked(TRUE);
			break;
		case 5:
			s32->setChecked(TRUE);
			break;
		case 6:
			s64->setChecked(TRUE);
			break;
		case 8:
			s256->setChecked(TRUE);
			break;
		case 7:
		default:
			s128->setChecked(TRUE);
			break;
	}
	switch( config->readNumEntry( "SizeOfPayload", 80 ) ) {
		case 80: s80->setChecked(TRUE); break;
		case 160: s160->setChecked(TRUE); break;
	}
	// Ringing tone
	ringing = new QHButtonGroup( "Ringing tone  (system bell)", vbox );
	QRadioButton *noRingingtone = new QRadioButton( "Don't use ringing tone", ringing );
	ringing->insert( noRingingtone, ringingtoneNo );
	QRadioButton *yesRingingtone = new QRadioButton( "Use ringing tone", ringing );
	ringing->insert( yesRingingtone, ringingtoneYes );
	config->setGroup( "General" );
	if( config->readEntry( "ringingtone", "No" ) == "Yes" ) {
		ringing->setButton( ringingtoneYes );
	} else {
		ringing->setButton( ringingtoneNo );
	}
}

AudioControl::~AudioControl( void )
{
}

void AudioControl::slotOk( void )
{
	slotApply();
	QDialog::accept();
}

void AudioControl::slotApply( void )
{
	a->setOSSFilename( dspdev->text() );
	a->saveAudioSettings();
	KConfig *config = KGlobal::config();
	config->setGroup( "Audio" );
	switch( bg1->id( bg1->selected() ) ) {
		case ulaw:
			config->writeEntry( "Codec", "ULAW");
			a->setCodec( codecULAW );
			break;
		case gsm:
			config->writeEntry( "Codec", "GSM");
			a->setCodec( codecGSM );
			break;
		case ilbc:
			config->writeEntry( "Codec", "ILBC");
			a->setCodec( codecILBC );
			break;
	}
	config->setGroup( "DSP" );
	int fragSize;
	int fragNum;
	switch( bg2->id( bg2->selected() ) ) {
		case size16:
			fragSize = 4;
			fragNum = 64;
			break;
		case size32:
			fragSize = 5;
			fragNum = 32;
			break;
		case size64:
			fragSize = 6;
			fragNum = 16;
			break;
		case size256:
			fragSize = 8;
			fragNum = 8;
			break;
		case size128:
		default:
			fragSize = 7;
			fragNum = 8;
			break;
	}
	a->setNumfrags( fragNum );
	a->setSize( fragSize );
	config->writeEntry( "SizeOfFragment", fragSize );
	config->writeEntry( "NumberOfFragment", fragNum );

	int payload;
	switch( bg3->id( bg3->selected() ) ) {
		case size80:
			payload = 80;
			break;
		case size160:
		default:
			payload = 160;
			break;
	}
	a->setPayload( payload );
	config->writeEntry( "SizeOfPayload", payload );

	config->setGroup( "General" );
	switch( ringing->id( ringing->selected() ) ) {
		case ringingtoneYes:
			config->writeEntry( "ringingtone", "Yes" );
			break;
		default:
			config->writeEntry( "ringingtone", "No" );
			break;
	}
	config->sync();
}

void AudioControl::slotCancel( void )
{
	dspdev->setText( a->getOSSFilename() );
	QDialog::reject();
}


VideoControl::VideoControl( CallAudio *callaudio, QWidget *parent, const char *name )
	: KDialogBase( parent, name, false, QString( name ) + "Video Properties", Ok|Apply|Cancel, Ok, true )
{
	a = callaudio;
	QVBox *vbox = makeVBoxMainWidget();
	KConfig *config = KGlobal::config();
	config->setGroup( "Video" );
	(void) new QLabel( "Video SW:", vbox );
	videoSW = new QLineEdit( config->readEntry( "videoSW", "/usr/local/bin/vic" ), vbox );
	videoSW->setMinimumWidth( fontMetrics().maxWidth() * 20 );
	bg1 = new QHButtonGroup( "Preferred Video Codec", vbox );
	QRadioButton *h261Button = new QRadioButton( "H261", bg1 );
	bg1->insert( h261Button, h261 );
	QRadioButton *h263Button = new QRadioButton( "H263", bg1 );
	bg1->insert( h263Button, h263 );
	QString codec = config->readEntry( "codec", "h261" );
	if( codec == "h261" ) {
		h261Button->setChecked(TRUE);
	} else if( codec == "h263" ) {
		h263Button->setChecked(TRUE);
	}
}

VideoControl::~VideoControl( void )
{
}

void VideoControl::slotOk( void )
{
	slotApply();
	QDialog::accept();
}

void VideoControl::slotApply( void )
{
	a->setVideoSW( videoSW->text() );
	KConfig *config = KGlobal::config();
	config->setGroup( "Video" );
	config->writeEntry( "videoSW", videoSW->text() );
	switch( bg1->id( bg1->selected() ) ) {
		case h261:
			config->writeEntry( "codec", "h261");
			a->setVideoCodec( codecH261 );
			break;
		case h263:
			config->writeEntry( "codec", "h263");
			a->setVideoCodec( codecH263 );
			break;
	}
	config->sync();
}

void VideoControl::slotCancel( void )
{
	QDialog::reject();
}

#include "audiocontrol.moc"
