#ifndef AUDIOCONTROL_H_INCLUDED
#define AUDIOCONTROL_H_INCLUDED

#include <kdialogbase.h>
#include <kpushbutton.h>

class QLineEdit;
class QRadioButton;
class CallAudio;
class DspOutOss;

class AudioControl : public KDialogBase
{
	Q_OBJECT
public:
	AudioControl( CallAudio *callaudio, QWidget *parent = 0, const char *name = 0 );
	~AudioControl( void );

protected slots:
	void slotOk( void );
	void slotApply( void );
	void slotCancel( void );

private:
	enum Codecs { ulaw, gsm, ilbc };
	enum SizeOfFragment { size16, size32, size64, size128, size256 };
	enum SizeOfPayload { size80, size160 };
	enum Ringingtone { ringingtoneYes, ringingtoneNo };
	QButtonGroup *bg1;
	QButtonGroup *bg2;
	QButtonGroup *bg3;
	CallAudio *a;
	QLineEdit *dspdev;
	QButtonGroup *ringing;
};

class VideoControl : public KDialogBase
{
	Q_OBJECT
public:
	VideoControl( CallAudio *callaudio, QWidget *parent = 0, const char *name = 0 );
	~VideoControl( void );

protected slots:
	void slotOk( void );
	void slotApply( void );
	void slotCancel( void );

private:
	enum Codecs { h261, h263 };
	QButtonGroup *bg1;
	CallAudio *a;
	QLineEdit *videoSW;
};

#endif // AUDIOCONTROL_H_INCLUDED
