#include <stdio.h>
#include <qnamespace.h>
#include <bhistoryline.h>

BHistoryLine::BHistoryLine( QWidget *parent, const char *name )
	: QLineEdit( parent, name )
{
	history.prepend( QString::null );
	pos = 0;
}

BHistoryLine::~BHistoryLine( void )
{
}

void BHistoryLine::keyPressEvent( QKeyEvent *kev )
{
	if( kev->key() == Qt::Key_Up ) {
		if( pos < history.count() - 1 ) {
			history[ pos++ ] = text();
			setText( history[ pos ] );
		}
	}

	if( kev->key() == Qt::Key_Down ) {
		if( pos > 0 ) {
			history[ pos-- ] = text();
			setText( history[ pos ] );
		}
	}

	if( kev->key() == Qt::Key_Return ) {
		if( text().length() > 0 ) {
			history[ 0 ] = text();
			history.prepend( QString::null );
			pos = 0;
		}
	}
		
	QLineEdit::keyPressEvent( kev );
}

#include "bhistoryline.moc"
