#ifndef BHISTORYLINE_H_INCLUDED
#define BHISTORYLINE_H_INCLUDED

#include <qstringlist.h>
#include <qlineedit.h>

/**
 * @short Line edit with command history.
 * @author Billy Biggs <vektor@div8.net>
 *
 * BHistoryLine is an extension of QLineEdit to support command
 * history using the up and down arrow keys.
 */
class BHistoryLine : public QLineEdit
{
	Q_OBJECT
public:
	/**
	 * Construct a new BHistoryLine.
	 */
	BHistoryLine( QWidget *parent = 0, const char *name = 0 );

	/**
	 * Destructor for BHistoryLine.
	 */
	~BHistoryLine( void );

protected:
	/**
	 * Reimplemented to check for the up and down arrow keys.
	 */
	virtual void keyPressEvent( QKeyEvent *kev );

private:
	QStringList history;
	unsigned int pos;
};

#endif // BHISTORYLINE_H_INCLUDED
