#ifndef CALLAUDIO_H_INCLUDED
#define CALLAUDIO_H_INCLUDED

#include <qobject.h>
#include <qstring.h>
#include <sys/types.h>
#include <dissipate2/sdp.h>

class DspDiverter;
class SipCall;
class SipCallMember;

class CallAudio : public QObject
{
	Q_OBJECT
public:
	CallAudio( void );
	~CallAudio( void );
	bool isOutputOSS( void ) const { return useoss; }
	void useOSS( void );
	void setOSSFilename( const QString &devname );
	const QString &getOSSFilename( void ) const { return ossfilename; }
	void setVideoSW( const QString &sw );
	const QString &getVideoSW( void ) const { return videoSW; }

	// Call attachment
	void attachToCallMember( SipCallMember *newmember );
	void detachFromCall( void );
	void toggleOnHold( void );
	void renegotiateCall( void );

	// Returns a session description for sending in responses
	SdpMessage listenForRtp( void );

	// Call tracking
	void setCurrentCall( SipCall *newcall );
	SipCall *getCurrentCall( void ) const { return curcall; }

	bool isRemoteHold( void );

	// Settings
	void saveAudioSettings( void );
	void readAudioSettings( void );

	void readVideoSettings( void );

	void setNumfrags( int newNumfrags ) { numfrags = newNumfrags; }
	void setSize( int newSize ) { size = newSize; }
	void setPayload( int newPayload ) { payload = newPayload; }
	bool isAudioOn( void );

	void setCodec( codecType newCodec ) { codec = newCodec; }
	void setRtpCodec( codecType newCodec ) { rtpCodec = newCodec; }
	void setVideoCodec( codecType newCodec ) { videoCodec = newCodec; }
	void setVideoRtpCodec( codecType newCodec ) { videoRtpCodec = newCodec; }
	codecType getRtpCodec( void );
	int getRtpCodecNum( void );
	codecType getVideoRtpCodec( void );
	int getVideoRtpCodecNum( void );
	QString getVideoRtpCodecName( void );
	void setBodyMask( QString body ) { bodyMask = body; }
	QString getBodyMask( void ) { return bodyMask; }
	bool checkCodec( SipCallMember *member );
	void setStunSrv( QString newStunSrv );

signals:
	void outputDead( void );
	void statusUpdated( void );

private slots:
	void memberStatusUpdated( void );

private:
	DspDiverter *input;
	DspDiverter *output;
	SdpMessage local;
	SdpMessage remote;
	bool useoss;
	QString ossfilename;
	QString videoSW;
	SipCall *curcall;
	SipCallMember *curmember;
	void sendToRemote( void );
	void stopSending( void );
	void stopListening( void );
	void detachAndHold( void );
	int numfrags;
	int size;
	int payload;
	codecType codec;
	codecType rtpCodec;
	codecType videoCodec;
	codecType videoRtpCodec;
	int rtpCodecNum;
	int videoRtpCodecNum;
	QString bodyMask;
	pid_t pidVideo;
	bool useStun;
	QString stunSrv;
};


#endif // CALLAUDIO_H_INCLUDED
