#include <dissipate2/sipclient.h>
#include <callaudio.h>
#include <calllistview.h>

ContactsListViewItem::ContactsListViewItem( bool subscribe, SipCall *c, QListView *parent )
	: QListViewItem( parent ), call( c )
{
	isSubscribe = subscribe;
	QObject::connect( call, SIGNAL( callStatusUpdated() ), listView(), SLOT( triggerUpdate() ) );
}

ContactsListViewItem::~ContactsListViewItem( void )
{
}

QString ContactsListViewItem::text( int col ) const
{
	switch( col ) {
		case 0: // Status
			return call->getPresenceStatus();
			break;
		case 1: // Subject
			return call->getContactStr();
			break;
		default:
			break;
	}
	return QString::null;
}

void ContactsListViewItem::paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int alignment )
{
	QColorGroup _cg( cg );
	QColor c = _cg.text();
	if( isSubscribe && column == 1 ) {
		 _cg.setColor( QColorGroup::Text, Qt::darkGreen );
	}
	QListViewItem::paintCell( p, _cg, column, width, alignment );
	 _cg.setColor( QColorGroup::Text, c );
}

ContactsListView::ContactsListView( SipClient *client, QWidget *parent, const char *name )
	: MenuListView( parent, name )
{
	c = client;
	addColumn( "Status" );
	addColumn( "Contact" );
	setColumnWidth( 1, fontMetrics().maxWidth() * 9 );
	setAllColumnsShowFocus( TRUE );
	setMultiSelection( FALSE );
	auditList();
}

ContactsListView::~ContactsListView( void )
{
}

void ContactsListView::auditList( void )
{
	bool isSubscribed = false;
	clear();
	SipCallIterator it( c->getCallList() );
	SipCallIterator it2( c->getCallList() );
	it.toFirst();
	for( it.toFirst(); it.current(); ++it ) {
		if( it.current()->getCallType() == SipCall::outSubscribeCall ) {
			isSubscribed = false;
			it2.toFirst();
			for( it2.toFirst(); it2.current(); ++it2 ) {
				if( it2.current()->getCallType() == SipCall::inSubscribeCall ) {
					if( it2.current()->getMember( it.current()->getSubject() ) ) {
						if( it2.current()->getCallStatus() == SipCall::callInProgress ) {
							isSubscribed = true;
						}
					}
				}
			}
			if( it.current()->getCallStatus() != SipCall::callDead ) {
				insertItem( new ContactsListViewItem( isSubscribed, it.current(), this ) );
			}
		}
	}
}

#include "calllistview.moc"
