#ifndef CALLLISTVIEW_H_INCLUDED
#define CALLLISTVIEW_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlist.h>
#include <qlistview.h>
#include <menulistview.h>
#include <dissipate2/sipcall.h>
#include <qcombobox.h>

class SipCall;
class SipClient;
class CallAudio;
class KPhoneView;
class QPainter;
class QColorGroup;


class ContactsListViewItem : public QListViewItem
{
public:
	ContactsListViewItem( bool subscribe, SipCall *c, QListView *parent );
	~ContactsListViewItem( void );

	virtual QString text( int col ) const;
	virtual void paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int alignment );

	SipCall *getCall( void ) { return call; }

private:
	bool isSubscribe;
	SipCall *call;
};

class ContactsListView : public MenuListView
{
	Q_OBJECT
public:
	ContactsListView( SipClient *client, QWidget *parent = 0, const char *name = 0 );
	~ContactsListView( void );

public slots:
	void auditList( void );

private:
	SipClient *c;
	KPhoneView *v;
};


#endif // CALLLISTVIEW_H_INCLUDED
