#include <stdio.h>
#include <math.h>
#include <string.h>
#include <defines.h>
#include <audiobuffer.h>
#include <dspaction.h>

DspAction::DspAction( void )
{
}

DspAction::~DspAction( void )
{
}

void DspAction::setLoop( bool loop )
{
	if( isloopable ) {
		done = !loop;
	}
}

void DspAction::stop( void )
{
	done = true;
}

DspSilenceAction::DspSilenceAction( unsigned int length, bool loop,
		unsigned int samplerate )
{
	done = !loop;

	// Silence is very loopable
	isloopable = true;

	// Length is in milliseconds
	len = samplerate * length * sizeof( sample_t ) / 1000;

	// Force len to be divisible by sizeof( sample_t )
	unsigned int x = len / sizeof( sample_t );
	len = x * sizeof( sample_t );
}

DspSilenceAction::~DspSilenceAction( void )
{
}

bool DspSilenceAction::completed( void )
{
	return done;
}

AudioBuffer *DspSilenceAction::process( void )
{
	AudioBuffer *sbuf = new AudioBuffer( len );
	bzero( sbuf->getData(), sbuf->getSize() );
	return sbuf;
}

DspDualToneAction::DspDualToneAction( unsigned int tone1, unsigned int tone2,
		unsigned int length, bool repeat,
		unsigned int volume, unsigned int samplerate )
{
	isloopable = true;
	freq1 = tone1;
	freq2 = tone2;
	done = !repeat;
	vol = volume;
	rate = samplerate;
	wave_index = 0;
	initial = true;

	// Length is in milliseconds
	len = samplerate * length * sizeof( sample_t ) / 1000;

	// Force len to be divisible by sizeof( sample_t )
	unsigned int x = len / sizeof( sample_t );
	len = x * sizeof( sample_t );
}

DspDualToneAction::~DspDualToneAction( void )
{
}

bool DspDualToneAction::completed( void )
{
	return done;
}

AudioBuffer *DspDualToneAction::process( void )
{
	double div1, div2;
	unsigned int i;

	AudioBuffer *audiobuf = new AudioBuffer( len );

	div1 = ( (double) rate ) / ( (double) freq1 );
	div2 = ( (double) rate ) / ( (double) freq2 );

	sample_t *buf = (sample_t *) audiobuf->getData();
	for( i = 0; i < ( len / sizeof( sample_t ) ); i++ ) {
		buf[ i ]  = sin( 2 * 3.14 * ( wave_index / div1 ) );
		buf[ i ] += sin( 2 * 3.14 * ( wave_index / div2 ) );

		wave_index++;

		if( ( i < vol ) && ( initial == true ) ) {
			buf[ i ] *= i * 100;
		} else if( ( i > ( ( len / sizeof( sample_t ) ) - vol ) ) && ( done == true ) ) {
			buf[ i ] *= ( ( len / sizeof( sample_t ) ) - i ) * 100;
		} else {
			buf[ i ] *= vol * 100;
		}
	}

	initial = false;
	return audiobuf;
}

