#include <stdio.h>
#include <dspout.h>
#include <dspaction.h>
#include <audiobuffer.h>
#include <dspcontrol.h>

DspControl::DspControl( DspOut *dspdev )
{
	dspout = dspdev;
	defaction = new DspSilenceAction( 64, true );
	actionbuf = defaction->process();
	actionbufpos = 0;
}

DspControl::~DspControl( void )
{
}

void DspControl::setDefaultAction( DspAction *action )
{
	defaction = action;
}

void DspControl::queueAction( DspAction *action )
{
	actionq.enqueue( action );
}

void DspControl::nukeQueue( void )
{
	actionq.clear();
}

void DspControl::doTick( void )
{
	if( dspout->getDeviceState() == DspOut::DeviceClosed ) return;

	for( unsigned int i = 0; i < dspout->writableFragments(); i++ ) {
		fillBuffer();
	}
}

void DspControl::fillBuffer( void )
{
	AudioBuffer &dspbuf = dspout->getBuffer();

	char *buf = (char *) dspbuf.getData();
	size_t bufpos = 0;

	while( bufpos < dspbuf.getSize() ) {

		if( actionbuf == 0 ) {
			if( actionq.isEmpty() ) {
				actionbuf = defaction->process();
				actionbufpos = 0;
			} else {
				actionbuf = actionq.head()->process();
				actionbufpos = 0;

				if( actionq.head()->completed() ) {
					actionq.remove();
				}
			}
		}

		char *abuf = (char *) actionbuf->getData();

		if( ( actionbuf->getSize() - actionbufpos ) < ( dspbuf.getSize() - bufpos ) ) {

			memcpy( buf, &(abuf[ actionbufpos ]), actionbuf->getSize() - actionbufpos );
			buf += actionbuf->getSize() - actionbufpos;
			bufpos += actionbuf->getSize() - actionbufpos;
			actionbufpos += actionbuf->getSize() - actionbufpos;

		} else {
			memcpy( buf, &(abuf[ actionbufpos ]), dspbuf.getSize() - bufpos );
			actionbufpos += dspbuf.getSize() - bufpos;
			bufpos = dspbuf.getSize();
		}

		if( actionbufpos == actionbuf->getSize() ) {
			delete actionbuf;
			actionbuf = 0;
			actionbufpos = 0;
		}

	}

	dspout->writeBuffer();
}

