#include <stdio.h>
#include <unistd.h>
#include <defines.h>
#include <audiobuffer.h>
#include <dspout.h>
#include <dspoutrtp.h>
#include <dspdiverter.h>

DspDiverter::DspDiverter( DspOut *in, DspOut *out )
	: input( in ), output( out )
{
	broken = false;
	isthreaded = false;
	copybuffer.resize( out->getBuffer().getSize() );
	curpos = 0;
}

DspDiverter::~DspDiverter( void )
{
	if( isthreaded ) stop();
	if( input ) delete input;
	if( output ) delete output;
}

void DspDiverter::thread_main( void )
{
	isthreaded = true;

	for(;;) {
		testcancel();
		timerTick();
		usleep( 0 );
	}
}

void DspDiverter::timerTick( void )
{
	if( broken ){
		printf("(b)");
		fflush(stdout);
		return;
	}

	sample_t *curbuf;
	unsigned int outputsize = output->getBuffer().getSize() / sizeof( sample_t );

	while( ( input->readableFragments() > 0 ) && !broken ) {

		// Read in a buffer
		testcancel();
		input->readBuffer();
		testcancel();

		unsigned int samplesleft = input->getBuffer().getSize() / sizeof( sample_t );
		sample_t *inbuf = (sample_t *) input->getBuffer().getData();

		/*
		printf( "[%s->%s] read a buffer, size %d, samples left %d\n",
			input->getDeviceName().ascii(),
			output->getDeviceName().ascii(),
			input->getBuffer()->getSize(),
			samplesleft );
		 */

		while( samplesleft > 0 ) {
			if( samplesleft >= ( outputsize - curpos ) ) {
				curbuf = (sample_t *) copybuffer.getData();
				curbuf += curpos;

				memcpy( curbuf, inbuf, ( outputsize - curpos ) * sizeof( sample_t ) );
				memcpy( output->getBuffer().getData(), copybuffer.getData(),
					output->getBuffer().getSize() );

				/*
				printf( "[%s->%s] writing buffer, output size %d, copy buffer size %d, curpos was %d\n",
					input->getDeviceName().ascii(), output->getDeviceName().ascii(),
					output->getBuffer()->getSize(), copybuffer->getSize(), curpos );
				 */

				// If the write fails, mark the pipe as broken and stop sending!
				testcancel();
				if( !output->writeBuffer() ) {
					testcancel();
					printf( "DspDiverter: Broken pipe\n" );
					broken = true;
				}
				testcancel();
				samplesleft -= ( outputsize - curpos );
				inbuf += ( outputsize - curpos );
				curpos = 0;
			} else {
				/*
				printf( "[%s->%s] filling in %d samples\n",
					input->getDeviceName().ascii(),
					output->getDeviceName().ascii(),
					samplesleft );
				 */
				curbuf = (sample_t *) copybuffer.getData();
				curbuf += curpos;

				memcpy( curbuf, inbuf, samplesleft * sizeof( sample_t ) );

				curpos += samplesleft;
				inbuf += samplesleft;

				samplesleft = 0;
			}
		}
	}
}

