#ifndef DSPDIVERTER_H_INCLUDED
#define DSPDIVERTER_H_INCLUDED

#include <thread.h>
#include <audiobuffer.h>

class DspOut;

class DspDiverter : public thread
{
public:
	DspDiverter( DspOut *in, DspOut *out );
	~DspDiverter( void );

	/**
	 * Start up a thread to handle the stream.
	 */
	bool run( void ) { return thread::run(); }

	/**
	 * Just do one tick, for non-threaded implementations.
	 */
	virtual void timerTick( void );

	/**
	 * Test if the pipe is broken.
	 */
	bool isBroken( void ) { return broken; }

protected:
	DspOut *input;
	DspOut *output;
	bool isthreaded;
	bool broken;

	virtual void thread_main( void );

private:
	AudioBuffer copybuffer;
	unsigned int curpos;
};

#endif // DSPDIVERTER_H_INCLUDED
