#include <defines.h>
#include <audiobuffer.h>
#include <dspeffect.h>

DspEffect::DspEffect( void )
{
}

DspEffect::~DspEffect( void )
{
}

void DspEffect::applyGain( AudioBuffer *buffer, float gain )
{
	sample_t *buf = (sample_t *) buffer->getData();
	for( unsigned int i = 0; i < ( buffer->getSize() / sizeof( sample_t ) ); i++ ) {
		*buf = (*buf) * gain;
		buf++;
	}
}

void DspEffect::applyStereoGain( AudioBuffer *buffer, float lgain, float rgain )
{
	sample_t *buf = (sample_t *) buffer->getData();
	for( unsigned int i = 0; i < ( buffer->getSize() / sizeof( sample_t ) / 2 ); i++ ) {
		*buf = (*buf) * lgain;
		buf++;
		*buf = (*buf) * rgain;
		buf++;
	}
}

