#ifndef DSPEFFECT_H_INCLUDED
#define DSPEFFECT_H_INCLUDED

class AudioBuffer;

class DspEffect
{
public:
	DspEffect( void );
	~DspEffect( void );

	/**
	 * Takes a buffer of sample_t's and applies a gain factor.
	 */
	static void applyGain( AudioBuffer *buffer, float gain );

	/**
	 * Takes a stereo buffer of sample_t's and applies a separate
	 * left and right gain.
	 */
	static void applyStereoGain( AudioBuffer *buffer, float lgain,
			float rgain );
};

#endif // DSPEFFECT_H_INCLUDED
