#include <stdio.h>
#include <unistd.h>
#include <defines.h>
#include <audiobuffer.h>
#include <dspout.h>
#include <dspoutrtp.h>
#include <dspfulldiverter.h>

DspFullDiverter::DspFullDiverter( DspOut *in, DspOut *out )
	: DspDiverter( in, out )
{
	udp_failures = 0;
	oss_empty = 0;
}

DspFullDiverter::~DspFullDiverter( void )
{
}

void DspFullDiverter::timerTick( void )
{

	// Don't beat stuff out if we're broken
	if( broken ) {
		printf("(B)");
		fflush(stdout);
		return;
	}

	while( ( input->readableFragments() > 0 ) && !broken ) {

		oss_empty = 0;

		testcancel();
		// Read in a buffer
		input->readBuffer();
		testcancel();

		// Make sure there's room in the output
		output->getBuffer().resize( input->getBuffer().getSize() );

		// Copy the data
		memcpy( output->getBuffer().getData(), input->getBuffer().getData(), input->getBuffer().getSize() );

		// If the write fails, mark the pipe as broken and stop sending!
		testcancel();
		if( !output->writeBuffer() ) {
			udp_failures++;
			testcancel();
			if(udp_failures > 5){
				broken = true;
				printf( "DspFullDiverter: Broken pipe\n" );
			} else {
				printf( "DspFullDiverter: UDP-failure(%d)\n", udp_failures );
			}
		} else {
			udp_failures = 0;
		}
		testcancel();
	}
	oss_empty ++;
	if( oss_empty > 5 ){
		oss_empty = 0;
		input->readBuffer();
	}
}

