#ifndef DSPOUTOSS_H_INCLUDED
#define DSPOUTOSS_H_INCLUDED

#include <sys/soundcard.h>
#include <dspout.h>

/**
 * @short OSS implementation of DspOut.
 * @author Billy Biggs <vektor@div8.net>
 *
 * This is the OSS implementation of DspOut for the /dev/dsp*
 * devices.  Note that you cannot change how many fragments
 * this class requests, yet.
 */
class DspOutOss : public DspOut
{
public:
	/**
	 * Constructs a DspOutOss object representing the given
	 * filename.  Default is /dev/dsp.
	 */
	DspOutOss( const QString &fileName = "/dev/dsp" );

	/**
	 * Destructor.  Will close the device if it is open.
	 */
	virtual ~DspOutOss( void );

	bool openDevice( DeviceMode mode );
	bool closeDevice( void );

	unsigned int writableFragments( void );
	bool writeBuffer( void );

	bool setSampleRate( int newrate );

	unsigned int readableFragments( void );
	bool readBuffer( void );
	void setNumfrags( int newNumfrags ) { numfrags = newNumfrags; }
	void setSize( int newSize ) { size = newSize; }

private:
	AudioBuffer output_buf;   // Output buffer
	QString filename;         // device filename
	int audio_fd;
	int numfrags;
	int size;
};

#endif  // DSPOUTOSS_H_INCLUDED
