#ifndef DSPOUTRTP_H_INCLUDED
#define DSPOUTRTP_H_INCLUDED

#include <dspout.h>
#include <dissipate2/udpmessagesocket.h>
#include <qtimer.h>
#include <callaudio.h>

/* GSM */
#include "kphonegsm/gsm.h"
#include "kphonegsm/private.h"

#define GSM_ENC_BYTES	33
#define GSM_DEC_SAMPLES	160
/*---*/

/* iLBC */
#include "ilbc/iLBC_define.h"
#include "ilbc/iLBC_encode.h"
#include "ilbc/iLBC_decode.h"
#define ILBCNOOFWORDS   (NO_OF_BYTES/2)
#define TIME_PER_FRAME  30
/*---*/

/**
 * @short RTP implementation of DspOut.
 * @author Billy Biggs <vektor@div8.net>
 *
 * This is the RTP implementation of DspOut.
 */
class DspOutRtp : public DspOut
{
public:
	/**
	 * Constructs a DspOutRtp object outputting to the given
	 * hostname.
	 */
	DspOutRtp( const codecType newCodec, int newCodecNum, const QString &hostName = QString::null );

	/**
	 * Destructor.  Will close the device if it is open.
	 */
	virtual ~DspOutRtp( void );

	bool openDevice( DeviceMode mode );
	bool closeDevice( void );

	unsigned int writableFragments( void );
	bool writeBuffer( void );

	bool setSampleRate( int newrate );

	bool setPortNum( int newport );
	int getPortNum( void ) const { return portnum; }
	int getVideoPortNum( void ) const { return videoPortnum; }

	unsigned int readableFragments( void );
	bool readBuffer( void );
	void setPayload( int payload ) { fixedrtplen = (size_t)payload; }
	bool sendStunRequest( UDPMessageSocket &socket );
	unsigned int receiveStunResponse( UDPMessageSocket &socket );
	void setStunSrv( QString newStunSrv );

private:
	int writeGSMBuffer( gsm Gsm_Inst,
		unsigned char *input_buf, unsigned char *output_buf,
		unsigned char *tmp_buf, unsigned char *queue,
		int *qlen, int size );
	int readGSMBuffer( gsm Gsm_Inst,
		unsigned char *input_buf, unsigned char *output_buf,
		int ignore );
	int writeILBCBuffer( iLBC_Enc_Inst_t *Enc_Inst,
		unsigned char *input_buf, unsigned char *output_buf,
		unsigned char *tmp_buf, unsigned char *queue,
		int *qlen, int size );
	int readILBCBuffer( iLBC_Dec_Inst_t *Dec_Inst,
		unsigned char *input_buf, unsigned char *output_buf,
		short mode, int ignore);

	UDPMessageSocket socket;      // UDP Socket
	int portnum;
	int videoPortnum;
	int output_fd;                // The fd of the audio output
	unsigned char *packetbuf;     // Buffer for the packet data
	double lasttime;
	short curseq;
	unsigned char *bufunsend;

	unsigned char *inbuf;
	unsigned char *outbuf;
	unsigned char *tmpbuf;
	unsigned char *quebuf;

//codec
	codecType codec;
	int codecNum;
	gsm gsmInstEnc;
	gsm gsmInstDec;
	int qlen;
	iLBC_Enc_Inst_t ilbcEncInst;
	iLBC_Dec_Inst_t ilbcDecInst;

	size_t numunsend;
	size_t fixedrtplen;
	int deb_period;
	int deb_period_default;
	unsigned long deb_frag;
	unsigned long deb_rtp;
	int ts;
	int ssrc;
	int ref_sec;
	int ref_usec;
	int dsize;
	bool useStun;
	QString stunSrv;
};

#endif  // DSPOUTRTP_H_INCLUDED
