#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <qdatetime.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qtimer.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qmultilineedit.h>
#include <kmessagebox.h>
#include <dissipate2/sdp.h>
#include <dissipate2/sipmessage.h>
#include <dissipate2/mimecontenttype.h>
#include <dissipate2/sipuser.h>
#include <dissipate2/sipcall.h>
#include <dissipate2/siptransaction.h>
#include <kglobal.h>
#include <kcombobox.h>
#include <kcompletion.h>
#include <kseparator.h>
#include <callaudio.h>
#include <kconfig.h>
#include <kglobal.h>
#include <qdir.h>
#include <qmessagebox.h>
#include <kphone.h>
#include <kphoneview.h>
#include <kiconloader.h>
#include <artsc/artsc.h>
#include <kcallwidget.h>


KCallTransfer::KCallTransfer( QWidget *parent, const char *name )
	: KDialogBase( parent, name, false, "Transfer Call", Ok|Cancel, Ok, true )
{
	QVBox *vbox = makeVBoxMainWidget();

	(void) new QLabel( "Transfer to URI:", vbox );
	touri = new QLineEdit( vbox );
	touri->setMinimumWidth( fontMetrics().maxWidth() * 20 );
}

KCallTransfer::~KCallTransfer( void )
{
}

void KCallTransfer::slotOk( void )
{
	if( touri->text().stripWhiteSpace() != QString::null ) {
		pleaseTransfer( touri->text() );
	}
	touri->clear();
	QDialog::accept();
}

void KCallTransfer::slotCancel( void )
{
	touri->clear();
	QDialog::reject();
}

KCallWidget::KCallWidget( CallAudio *callaudio, SipCall *initcall, QWidget *parent, const char *name )
	: QDialog( parent, name, FALSE, WStyle_DialogBorder ), call( initcall )
{
	missedCalls.setAutoDelete( true );
	receivedCalls.setAutoDelete( true );
	hided = false;
	phoneBook = 0;
	curstate = PreDial;
	member = 0;
	transfer = 0;

	audio = callaudio;
	connect( audio, SIGNAL( outputDead() ), this, SLOT( audioOutputDead() ) );
	connect( audio, SIGNAL( statusUpdated() ), this, SLOT( updateAudioStatus() ) );

	ringCount = 0;
	ringTimer = new QTimer();
	connect( ringTimer, SIGNAL( timeout() ), this, SLOT( ringTimeout() ) );
	acceptCallTimer = new QTimer();
	connect( acceptCallTimer, SIGNAL( timeout() ), this, SLOT( acceptCallTimeout() ) );

	QVBoxLayout *vbox = new QVBoxLayout( this );
	vbox->setMargin( 3 );
	vbox->setSpacing( 3 );

	QGridLayout *headergrid = new QGridLayout( 2, 3 );
	headergrid->setSpacing( 3 );

	vbox->insertLayout( 0, headergrid );

	// Remote (person we're calling)
	QLabel *remotelabel = new QLabel( "Remote: ", this );
	remotelabel->setFixedWidth( remotelabel->fontMetrics().width( "  Remote:  "  ) );
	headergrid->addWidget( remotelabel, 0, 0 );

	remote = new KComboBox( true, this );
	remote->setContextMenuEnabled( true );
	remote->setCompletionMode( KGlobalSettings::CompletionAuto );
	headergrid->addWidget( remote, 0, 1 );

	// Remember to give remote completion
	remotecomp = remote->completionObject();

	int count = 0;
	QString s;
	QString remoteuri;
	KConfig *config = KGlobal::config();
	QString label = getUserPrefix() + "Call register";
	config->setGroup( label );
	label = "Dialled" + s.setNum( count );
	remoteuri = config->readEntry( label, "" );
	while( !remoteuri.isEmpty() && count < 20 ) {
		remote->insertItem( remoteuri );
		label = "Dialled" + s.setNum( ++count );
		remoteuri = config->readEntry( label, "" );
	}

	QPushButton *loadUri = new QPushButton( "", this );
	QIconSet icon;
	icon.setPixmap( KGlobal::iconLoader()->loadIcon( "phonebook", KIcon::Small ), QIconSet::Automatic );
	loadUri->setIconSet( icon );
	loadUri->setFixedWidth( loadUri->fontMetrics().maxWidth() * 2 );
	connect( loadUri, SIGNAL( clicked() ), this, SLOT( getUri() ) );
	headergrid->addWidget( loadUri, 0, 2 );
	KSeparator *separator = new KSeparator( QFrame::HLine, this );
	vbox->insertWidget( 1, separator );

	QHBox *statline = new QHBox( this );
	statline->setSpacing( 5 );
	vbox->insertWidget( 2, statline );

	QLabel *statlabel = new QLabel( "Status: ", statline );
	statlabel->setFixedWidth( remotelabel->width() );
	curstat = new QLabel( statline );

	QLabel *astatlabel = new QLabel( "Audio: ", statline );
	astatlabel->setFixedWidth( remotelabel->width() );
	curaudiostat = new QLabel( statline );

	separator = new KSeparator( QFrame::HLine, this );
	vbox->insertWidget( 3, separator );

	QHBox *buttonbox = new QHBox( this );
	buttonbox->setSpacing( 5 );
	vbox->insertWidget( 4, buttonbox );

	(void) new QWidget( buttonbox );

	dial = new QPushButton( "Dial", buttonbox );
	QIconSet icon1;
	icon1.setPixmap( KGlobal::iconLoader()->loadIcon( "dial", KIcon::Small ), QIconSet::Automatic );
	dial->setIconSet( icon1 );
	connect( dial, SIGNAL( clicked() ), this, SLOT( dialClicked() ) );
	dial->setEnabled( true );
	hangup = new QPushButton( "Hangup", buttonbox );
	QIconSet icon2;
	icon2.setPixmap( KGlobal::iconLoader()->loadIcon( "hangup", KIcon::Small ), QIconSet::Automatic );
	hangup->setIconSet( icon2 );

	connect( hangup, SIGNAL( clicked() ), this, SLOT( hangupCall() ) );
	hangup->setEnabled( false );

	(void) new QWidget( buttonbox );

	holdbutton = new QPushButton( "Hold", buttonbox );
	connect( holdbutton, SIGNAL( clicked() ), this, SLOT( holdCall() ) );

	transferbutton = new QPushButton( "Transfer", buttonbox );
	connect( transferbutton, SIGNAL( clicked() ), this, SLOT( showTransferDialog() ) );

	hidebutton = new QPushButton( "Hide", buttonbox );
	connect( hidebutton, SIGNAL( clicked() ), this, SLOT( hideCall() ) );

	QDateTime dt;
	int year,month,day,hour,min,sec;
	count = 0;
	label = getUserPrefix() + "Call register";
	config->setGroup( label );
	label.setNum( count );
	label = "Received" + label;
	s = config->readEntry( label, "" );
	while( !s.isEmpty() ) {
		year = s.left( s.find( '.' ) ).toInt();
		s = s.mid( s.find( '.' ) + 1 );
		month = s.left( s.find( '.' ) ).toInt();
		s = s.mid( s.find( '.' ) + 1 );
		day = s.left( s.find( '-' ) ).toInt();
		s = s.mid( s.find( '-' ) + 1 );
		hour = s.left( s.find( ':' ) ).toInt();
		s = s.mid( s.find( ':' ) + 1 );
		min = s.left( s.find( ':' ) ).toInt();
		s = s.mid( s.find( ':' ) + 1 );
		sec = s.left( s.find( '[' ) ).toInt();
		dt.setDate( QDate( year, month, day ) );
		dt.setTime( QTime( hour, min, sec ) );
		s = s.left( s.find( ']' ) );
		s = s.mid( s.find( '[' ) + 1 );
		incomingCall = new IncomingCall( s, dt );
		receivedCalls.append( incomingCall );
		label.setNum( ++count );
		label = "Received" + label;
		s = config->readEntry( label, "" );
	}
	count = 0;
	label.setNum( count );
	label = "Missed" + label;
	s = config->readEntry( label, "" );
	while( !s.isEmpty() ) {
		year = s.left( s.find( '.' ) ).toInt();
		s = s.mid( s.find( '.' ) + 1 );
		month = s.left( s.find( '.' ) ).toInt();
		s = s.mid( s.find( '.' ) + 1 );
		day = s.left( s.find( '-' ) ).toInt();
		s = s.mid( s.find( '-' ) + 1 );
		hour = s.left( s.find( ':' ) ).toInt();
		s = s.mid( s.find( ':' ) + 1 );
		min = s.left( s.find( ':' ) ).toInt();
		s = s.mid( s.find( ':' ) + 1 );
		sec = s.left( s.find( '[' ) ).toInt();
		dt.setDate( QDate( year, month, day ) );
		dt.setTime( QTime( hour, min, sec ) );
		s = s.left( s.find( ']' ) );
		s = s.mid( s.find( '[' ) + 1 );
		incomingCall = new IncomingCall( s, dt );
		missedCalls.append( incomingCall );
		label.setNum( ++count );
		label = "Missed" + label;
		s = config->readEntry( label, "" );
	}
	switchCall( initcall );
}

KCallWidget::~KCallWidget( void )
{
	delete ringTimer;
	delete acceptCallTimer;
	missedCalls.clear();
	receivedCalls.clear();
	if( call ) {
		delete call;
	}
	if( transfer ) {
		delete transfer;
	}
	if( phoneBook ) {
		delete phoneBook;
	}
}

void KCallWidget::setRemote( QString newremote )
{
	remote->setEditText( newremote );
}

SipCall *KCallWidget::getCall()
{
	return call;
}

void KCallWidget::switchCall( SipCall *newcall )
{
	ringTimer->stop();
	printf( "KCallWidget: Switching calls...\n" );
	call = newcall;
	audio->setBodyMask( call->getSdpMessageMask() );
	dial->setText( "Dial" );
	hangup->setText( "Hangup" );
	if( member ) disconnect( member, 0, this, 0 );
	member = call->getMemberList().toFirst();
	if( member ) {
		if( member->getStatus() == SipCallMember::Disconnected ) {
			forceDisconnect();
			return;
		}
		if( member->getStatus() == SipCallMember::Redirected ) {
			handleRedirect();
			return;
		}
		curstat->setText( member->getLocalStatusDescription() );
		connect( member, SIGNAL( statusUpdated() ), this, SLOT( callMemberStatusUpdated() ) );
		setCaption( getUserPrefix() + QString( "Call: " ) + call->getCallId() );
		if( call->getSubject() == "Incoming call" ) {
			if( call->getCallType() == SipCall::videoCall ) {
				setCaption( getUserPrefix() + QString( "Incoming Video Call: " ) + call->getCallId() );
				holdbutton->setEnabled( false );
				transferbutton->setEnabled( false );
			} else {
				setCaption( getUserPrefix() + QString( "Incoming Call: " ) + call->getCallId() );
				holdbutton->setEnabled( true );
				transferbutton->setEnabled( true );
			}
			QString ss = member->getUri().uri();
			QDateTime t = QDateTime::currentDateTime();
			incomingCall = new IncomingCall( ss, t );
			missedCalls.append( incomingCall );
			updateCallRegister();

			// Ringing tone
			KConfig *config = KGlobal::config();
			config->setGroup( "General" );
			isRingingTone = ( config->readEntry( "ringingtone", "No" ).upper() == "YES" );
			ringCount = 0;
			ringTimer->start( ringTime_1, TRUE );
		}
		remote->setEditText( member->getUri().uri() );
		subject = call->getSubject();
		hangup->setEnabled( true );
		if( member->getStatus() == SipCallMember::InviteRequested ) {
			hidebutton->setEnabled( false );
			dial->setEnabled( false );
			hangup->setEnabled( true );
			curstate = Calling;
		} else if( member->getStatus() == SipCallMember::RequestingInvite ) {
			dial->setText( "Accept" );
			hangup->setText( "Reject" );
			hidebutton->setEnabled( false );
			dial->setEnabled( true );
			hangup->setEnabled( true );
			curstate = Called;
		} else {
			hidebutton->setEnabled( false );
			dial->setEnabled( false );
			hangup->setEnabled( true );
			curstate = Connected;
		}
	} else {
		curstat->setText( QString::null );
		if( call->getCallType() == SipCall::videoCall ) {
			setCaption( getUserPrefix() + QString( "Outgoing Video Call: " ) + call->getCallId() );
			holdbutton->setEnabled( false );
			transferbutton->setEnabled( false );
		} else {
			setCaption( getUserPrefix() + QString( "Outgoing Call: " ) + call->getCallId() );
			holdbutton->setEnabled( true );
			transferbutton->setEnabled( true );
		}
		subject = call->getSubject();
		remote->setEditText( QString::null );
		hidebutton->setEnabled( true );
		dial->setEnabled( true );
		hangup->setEnabled( false );
		curstate = PreDial;
	}
	updateAudioStatus();
}

void KCallWidget::dialClicked( void )
{
	// Multi-purpose buttons hack
	if( curstate == Called ) {
		missedCalls.setAutoDelete( false );
		missedCalls.remove( incomingCall );
		missedCalls.setAutoDelete( true );
		receivedCalls.append( incomingCall );
		updateCallRegister();
		acceptCall();
		return;
	}
	if( remote->currentText().length() == 0 ) {
		KMessageBox::error( this, "You must specify someone to call.", "Error: No Destination" );
		return;
	}
	if( !audio->isAudioOn() ) {
		KConfig *config = KGlobal::config();
		config->setGroup( "General" );
		audio_fd = ::open( "/dev/dsp", O_WRONLY | O_NONBLOCK );
		if( audio_fd == -1 ) {
			QMessageBox::information( this, "Dial", "Close any program which might be using soundcard \nand then retry dial." );
			return;
		} else {
			::close( audio_fd );
		}
	}
	QString strRemoteUri;
	QString s = remote->currentText();
	if( s.contains( '[' ) && s.contains( ']' ) ) {
		strRemoteUri = s.mid( s.find( '[' ) + 1, s.find( ']' ) - s.find( '[' ) - 1 );
	} else {
		if( s.left( 4 ).lower() != "sip:" ) {
			s = "sip:" + s;
		}
		if( !s.contains( '@' ) ) {
			s = s + "@" + call->getHostname();
		}
		strRemoteUri = s;
	}
	remotecomp->addItem( s );
	for( int i = 0; i < remote->count(); i++ ) {
		if( remote->text( i ).compare( s ) == 0 ) {
			remote->removeItem( i );
		}
	}
	remote->insertItem( s, 0 );
	remote->setCurrentItem( 0 );
	KConfig *config = KGlobal::config();
	QString label = getUserPrefix() + "Call register";
	config->setGroup( label );
	QString str;
	for( int i = 0; i < remote->count(); i++ ) {
		label = "Dialled" + str.setNum( i );
		config->writeEntry( label, remote->text(i).latin1() );
	}
	label = "Dialled" + str.setNum( remote->count() );
	config->writeEntry( label, "" );
	config->sync();
	SipUri remoteuri( strRemoteUri );
	audio->setRtpCodec( codecUnknown );
	audio->setVideoRtpCodec( codecUnknown );
	member = new SipCallMember( call, remoteuri );
	audio->setCurrentCall( call );
	if( member->requestInvite(
			audio->listenForRtp().message( audio->getRtpCodec(), audio->getVideoRtpCodec(), audio->getBodyMask() ),
			MimeContentType( "application/sdp" ) ) ) {
		connect( member, SIGNAL( statusUpdated() ), this, SLOT( callMemberStatusUpdated() ) );
		// Accept call and listen for incoming audio
		audio->setCurrentCall( call );
		audio->attachToCallMember( member );
		hidebutton->setEnabled( false );
		dial->setEnabled( false );
		hangup->setEnabled( true );
		curstate = Calling;
		curstat->setText( member->getLocalStatusDescription() );
	} else {
		KMessageBox::error( this, member->getLocalStatusDescription(), "KPhone" );
	}
}

void KCallWidget::callMemberStatusUpdated( void )
{
	SdpMessage sdpm;
	SdpMessage rsdp;
	if( member->getStatus() == SipCallMember::Disconnected ) {
		if( member->getLocalStatusDescription().left( 12 ) == "Call Failed:" ) {
			curstat->setText( "Call Failed" );
			KMessageBox::error( this, member->getLocalStatusDescription(), "KPhone" );
			setHide();
		} else {
			curstat->setText( member->getLocalStatusDescription() );
		}
		forceDisconnect();
	} else if( member->getStatus() == SipCallMember::Redirected ) {
		curstat->setText( member->getLocalStatusDescription() );
		handleRedirect();
	} else if( member->getStatus() == SipCallMember::Connected ) {
		curstat->setText( member->getLocalStatusDescription() );
		hidebutton->setEnabled( false );
		dial->setEnabled( false );
		hangup->setEnabled( true );
		curstate = Connected;
	} else {
		curstat->setText( member->getLocalStatusDescription() );
	}
}

void KCallWidget::audioOutputDead( void )
{
	printf( "KCallAudio: Broken output pipe, disconnecting unpolitely\n" );
	forceDisconnect();
}

void KCallWidget::hangupCall( void )
{
	ringTimer->stop();

	// Reject call if that's our current state
	if( curstate == Called ) {
		member->declineInvite();
		setHide();
		return;
	}
	if( call->getCallStatus() != SipCall::callDead ) {
		hangup->setEnabled( false );
		if( member->getStatus() == SipCallMember::Connected ) {
			member->requestDisconnect();
		} else {
			member->cancelTransaction();
		}
		setHide();
		return;
	}
}

void KCallWidget::acceptCall( void )
{
	ringTimer->stop();
	acceptCallTimer->start( acceptTime, true );
}

void KCallWidget::holdCall( void )
{
	if( audio->getCurrentCall() == call ) {
		audio->toggleOnHold();
	} else if( member ) {
		audio->setCurrentCall( call );
		audio->attachToCallMember( member );
		audio->toggleOnHold();
	}
}

void KCallWidget::handleRedirect( void )
{
	printf( "KCallWidget: Handling redirect...\n" );
	SipUri redirto = member->getRedirectList().getHead();
	if( audio->getCurrentCall() == call ) {
		audio->detachFromCall();
	}
	if( member ) disconnect( member, 0, this, 0 );
	member = 0;
	if( call ) delete call;
	call = 0;
	redirectCall( redirto, subject );
	setHide();
}

void KCallWidget::forceDisconnect( void )
{
	printf( "KCallWidget: Starting force disconnect...\n" );
	if( audio->getCurrentCall() == call ) {
		audio->detachFromCall();
	}
	if( member ) disconnect( member, 0, this, 0 );
	member = 0;
	if( call ) delete call;
	call = 0;
	callDeleted();
	ringTimer->stop();
	setHide();
}

void KCallWidget::updateAudioStatus( void )
{
	if( audio->getCurrentCall() == call ) {
		if( audio->isRemoteHold() )
			curaudiostat->setText( "Attached [holding]" );
		else
			curaudiostat->setText( "Attached [active]" );
	} else {
		curaudiostat->setText( "Unattached" );
	}
}

void KCallWidget::clickDial()
{
	dialClicked();
}

void KCallWidget::pleaseDial( const SipUri &dialuri )
{
	remote->setEditText( dialuri.nameAddr() );
	dialClicked();
}

void KCallWidget::showTransferDialog( void )
{
	if( !transfer ) {
		transfer = new KCallTransfer;
		connect( transfer, SIGNAL( pleaseTransfer( const QString & ) ),
			this, SLOT( pleaseTransfer( const QString & ) ) );
	}
	transfer->show();
}

void KCallWidget::pleaseTransfer( const QString &transferto )
{
	// Ignore this button if there is no call setup yet.
	if( curstate != Connected ) return;
	if( call->getCallStatus() != SipCall::callDead ) {
		hangup->setEnabled( false );
		hidebutton->setEnabled( true );
		member->requestTransfer( SipUri( transferto ) );
		return;
	}
}

void KCallWidget::getUri( void )
{
	KConfig *config = KGlobal::config();
	QString label = getUserPrefix() + "Local";
	config->setGroup( label );
	QString xmlFile = config->readEntry( "PhoneBook", "" );
	if( xmlFile.isEmpty() ) {
		if( getUserPrefix().isEmpty() ) {
			xmlFile = QDir::homeDirPath() + "/.kphone-phonebook.xml";
		} else {
			xmlFile = QDir::homeDirPath() + "/.kphone" + getUserPrefix() + "phonebook.xml";
		}
	}
	QStringList r;
	if( !phoneBook ) {
		phoneBook = new PhoneBook(xmlFile, this, getUserPrefix() + "Phone Book", receivedCalls, missedCalls, r );
	}
	phoneBook->exec();
	remote->setEditText( phoneBook->getUri() );
	((KPhoneView *)parentWidget())->updateContacts( xmlFile );
}

void KCallWidget::updateCallRegister( void )
{
	QString s, ss, s1, s2, s3;
	QTime t;
	QDate d;
	QString label;
	IncomingCall *c;
	IncomingCall *first;
	int count = 0;

	KConfig *config = KGlobal::config();
	label = getUserPrefix() + "Call register";
	config->setGroup( label );
	label.setNum( count );
	label = "Missed" + label;
	s = config->readEntry( label, "" );
	while( !s.isEmpty() ) {
		config->writeEntry( label, "");
		label.setNum( ++count );
		label = "Missed" + label;
		s = config->readEntry( label, "" );
	}
	count = 0;
	label.setNum( count );
	label = "Received" + label;
	s = config->readEntry( label, "" );
	while( !s.isEmpty() ) {
		config->writeEntry( label, "");
		label.setNum( ++count );
		label = "Received" + label;
		s = config->readEntry( label, "" );
	}

	int i = 0;
	int last = receivedCalls.count();
	if ( last > 30 ) {
		first = receivedCalls.at( last - 30 );
	} else {
		first = receivedCalls.first();
	}
	for ( c = first; c != 0; c = receivedCalls.next() ) {
		label.setNum( i++ );
		label = "Received" + label;
		t = c->getDateTime().time();
		d = c->getDateTime().date();
		ss = s1.setNum( d.year() ) + "." + s2.setNum( d.month() ) +	"." + s3.setNum( d.day() ) + "-" + t.toString();
		config->writeEntry( label, ss + " [" + c->getContact() + "]");
	}
	i = 0;
	last = missedCalls.count();
	if ( last > 30 ) {
		first = missedCalls.at( last - 30 );
	} else {
		first = missedCalls.first();
	}
	for ( c = first; c != 0; c = missedCalls.next() ) {
		label.setNum( i++ );
		label = "Missed" + label;
		t = c->getDateTime().time();
		d = c->getDateTime().date();
		ss = s1.setNum( d.year() ) + "." + s2.setNum( d.month() ) +	"." + s3.setNum( d.day() ) + "-" + t.toString();
		config->writeEntry( label, ss + "[" + c->getContact() + "]");
	}
}


void KCallWidget::ringTimeout( void )
{
	if( isRingingTone ) {
		if( ringCount < 5 ) {
			ringCount++;
			printf( "\07" );
			fflush( stdout );
			ringTimer->start( ringTime_1, TRUE );
		} else {
			ringCount = 0;
			printf( "Ringing tone\n" );
			ringTimer->start( ringTime_2, TRUE );
		}
	}
}

void KCallWidget::acceptCallTimeout( void )
{
	if( !audio->isAudioOn() ) {	
		if( isRingingTone ) {
			if( arts_init() >= 0 ) {
				arts_suspend();
				arts_free();
			}
		}
		audio_fd = ::open( "/dev/dsp", O_WRONLY | O_NONBLOCK );
		if( audio_fd == -1 ) {
			QMessageBox::information( this, "Accept Call", "Close any program which might be using soundcard \nand then retry accepting call." );
			return;
		} else {
			::close( audio_fd );
		}
	}
	if( audio->checkCodec( member ) ) {
		audio->setCurrentCall( call );
		audio->attachToCallMember( member );
		member->acceptInvite(
			audio->listenForRtp().message( audio->getRtpCodec(), audio->getVideoRtpCodec(), audio->getBodyMask() ),
			MimeContentType( "application/sdp" ) );
		dial->setText( "Dial" );
		hangup->setText( "Hangup" );
		hidebutton->setEnabled( false );
		dial->setEnabled( false );
		hangup->setEnabled( true );
	} else {
		member->notAcceptableHere();
		QMessageBox::information( this, "Accept Call", "Accepted codec not found." );
	}
}

void KCallWidget::hideCall( void )
{
	if( curstate == PreDial ) {
		delete call;
		call = 0;
	}
	setHide();
}

QString KCallWidget::getUserPrefix( void )
{
	return ((KPhone *)parentWidget()->parentWidget())->getUserPrefix();
}

void KCallWidget::setHide( void )
{
	hided = true;
	hide();
}

KInstantMessageWidget::KInstantMessageWidget( SipCall *initcall, QWidget *parent, const char *name )
	: QDialog( parent, name ), imcall( initcall )
{
	phoneBook = 0;
	setCaption( getUserPrefix() + " Message - KPhone" );
	QVBoxLayout *vbox = new QVBoxLayout( this );
	vbox->setMargin( 3 );
	vbox->setSpacing( 3 );
	QGridLayout *headergrid = new QGridLayout( 2, 3 );
	headergrid->setSpacing( 3 );
	vbox->insertLayout( 0, headergrid );

	// Remote
	QLabel *remotelabel = new QLabel( "Remote: ", this );
	remotelabel->setFixedWidth( remotelabel->fontMetrics().width( "  Remote:  "  ) );
	headergrid->addWidget( remotelabel, 0, 0 );
	remote = new KComboBox( true, this );
	remote->setContextMenuEnabled( true );
	remote->setCompletionMode( KGlobalSettings::CompletionAuto );
	remote->setEditText( "" );
	headergrid->addWidget( remote, 0, 1 );

	// Remember to give remote completion
	remotecomp = remote->completionObject();
	QString s;
	QString remoteuri;
	QPushButton *loadUri = new QPushButton( "", this );
	QIconSet icon;
	icon.setPixmap( KGlobal::iconLoader()->loadIcon( "phonebook", KIcon::Small ), QIconSet::Automatic );
	loadUri->setIconSet( icon );
	loadUri->setFixedWidth( loadUri->fontMetrics().maxWidth() * 2 );
	connect( loadUri, SIGNAL( clicked() ), this, SLOT( getUri() ) );
	headergrid->addWidget( loadUri, 0, 2 );
	KSeparator *separator = new KSeparator( QFrame::HLine, this );
	vbox->insertWidget( 1, separator );
	QLabel *slabel = new QLabel( "Status: ", this );
	vbox->insertWidget( 2, slabel );
	status = new QMultiLineEdit( this );
	status->setReadOnly( true );
	vbox->insertWidget( 3, status );
	QLabel *mlabel = new QLabel( "Message: ", this );
	vbox->insertWidget( 4, mlabel );
	QGridLayout *mgrid = new QGridLayout( 1, 3 );
	mgrid->setSpacing( 3 );
	vbox->insertLayout( 5, mgrid );
	mEdit = new QMultiLineEdit( this );
	mgrid->addWidget( mEdit, 0,0 );
	QPushButton *mbutton = new QPushButton( "Send", this );
	mbutton->setFixedWidth( mbutton->fontMetrics().maxWidth() * 4 );
	connect( mbutton, SIGNAL( clicked() ), this, SLOT( mClicked() ) );
	mgrid->addWidget( mbutton, 0, 2 );
	separator = new KSeparator( QFrame::HLine, this );
	vbox->insertWidget( 6, separator );
	QHBox *buttonbox = new QHBox( this );
	buttonbox->setSpacing( 5 );
	vbox->insertWidget( 7, buttonbox );
	(void) new QWidget( buttonbox );
	(void) new QWidget( buttonbox );
	(void) new QWidget( buttonbox );
	(void) new QWidget( buttonbox );
	QPushButton *hidebutton = new QPushButton( "Hide", buttonbox );
	connect( hidebutton, SIGNAL( clicked() ), this, SLOT( hide() ) );
	resize( 400, 200 );
}

KInstantMessageWidget::~KInstantMessageWidget( void )
{
	if( phoneBook ) {
		delete phoneBook;
	}
}

void KInstantMessageWidget::instantMessage( SipMessage *message )
{
	QString s = message->getHeaderData( SipHeader::From );
	SipUri u = SipUri( s );
	remote->setEditText( u.getUsername() + "@" + u.getHostname() );
	QString m = message->messageBody();
	status->setText( "\n > " + m + "\n" + status->text() );
	status->setText( "Message received from " + remote->currentText() + status->text() );
}

SipCall *KInstantMessageWidget::getCall()
{
	return imcall;
}

QString KInstantMessageWidget::getRemote()
{
	return remote->currentText();
}

void KInstantMessageWidget::setRemote( QString newremote )
{
	remote->setEditText( newremote );
}

void KInstantMessageWidget::mClicked( void )
{
	if( remote->currentText().length() == 0 ) {
		KMessageBox::error( this, "You must specify someone to send message.", "Error: No Destination" );
		return;
	}
	QString strRemoteUri;
	QString s = remote->currentText();
	if( s.contains( '[' ) && s.contains( ']' ) ) {
		strRemoteUri = s.mid( s.find( '[' ) + 1, s.find( ']' ) - s.find( '[' ) - 1 );
	} else {
		if( s.left( 4 ).lower() != "sip:" ) {
			s = "sip:" + s;
		}
		if( !s.contains( '@' ) ) {
			s = s + "@" + imcall->getHostname();
		}
		strRemoteUri = s;
	}
	remotecomp->addItem( s );
	for( int i = 0; i < remote->count(); i++ ) {
		if( remote->text( i ).compare( s ) == 0 ) {
			remote->removeItem( i );
		}
	}
	remote->insertItem( s, 0 );
	remote->setCurrentItem( 0 );
	SipUri remoteuri( strRemoteUri );
	member = new SipCallMember( imcall, remoteuri );
	status->setText( "\n > " + mEdit->text() + "\n" + status->text() );
	status->setText( "Message sent to " + remote->currentText() + status->text() );
	if( member->requestMessage( mEdit->text(), MimeContentType( "text/plain; charset=UTF-8" ) ) ) {
		mEdit->clear();
	}
}

void KInstantMessageWidget::getUri( void )
{
	KConfig *config = KGlobal::config();
	QString label = getUserPrefix() + "Local";
	config->setGroup( label );
	QString xmlFile = config->readEntry( "PhoneBook", "" );
	if( xmlFile.isEmpty() ) {
		if( getUserPrefix().isEmpty() ) {
			xmlFile = QDir::homeDirPath() + "/.kphone-phonebook.xml";
		} else {
			xmlFile = QDir::homeDirPath() + "/.kphone" + getUserPrefix() + "phonebook.xml";
		}
	}
	QStringList r;
	if( !phoneBook ) {
		phoneBook = new PhoneBook(xmlFile, this, getUserPrefix() + "Phone Book", receivedCalls, missedCalls, r );
	}
	phoneBook->exec();
	remote->setEditText( phoneBook->getUri() );
	((KPhoneView *)parentWidget())->updateContacts( xmlFile );
}


QString KInstantMessageWidget::getUserPrefix( void )
{
	return ((KPhone *)parentWidget()->parentWidget())->getUserPrefix();
}

#include "kcallwidget.moc"
