#ifndef KCALLWIDGET_H_INCLUDED
#define KCALLWIDGET_H_INCLUDED

#include <qdialog.h>
#include <qptrdict.h>
#include <kdialogbase.h>
#include <ksipuserinfo.h>
#include <dissipate2/sipuri.h>
#include <time.h>

class QLabel;
class QLineEdit;
class KComboBox;
class KCompletion;
class QPushButton;
class QMultiLineEdit;
class SipUser;
class SipCall;
class SipCallMember;
class SipTransaction;
class CallAudio;
class IncomingCall;
class SipMessage;
class KPhoneView;


class KCallTransfer : public KDialogBase
{
	Q_OBJECT
public:
	KCallTransfer( QWidget *parent = 0, const char *name = 0 );
	~KCallTransfer( void );

signals:
	void pleaseTransfer( const QString & );

protected slots:
	void slotOk( void );
	void slotCancel( void );

private:
	QLineEdit *touri;
};

class KCallWidget : public QDialog
{
	Q_OBJECT
public:
	KCallWidget( CallAudio *callaudio, SipCall *initcall, QWidget *parent = 0, const char *name = 0 );
	~KCallWidget( void );
	SipCall *getCall();
	void switchCall( SipCall *newcall );
	void setRemote( QString newremote );
	void clickDial( void );
	void setHide( void );
	bool isHided( void ) const { return hided; }

public slots:
	void pleaseDial( const SipUri &dialuri );

signals:
	void callDeleted( void );
	void redirectCall( const SipUri &calluri, const QString &subject );

private slots:
	void hangupCall( void );
	void dialClicked( void );
	void audioOutputDead( void );
	void acceptCall( void );
	void holdCall( void );
	void callMemberStatusUpdated( void );
	void updateAudioStatus( void );
	void handleRedirect( void );
	void showTransferDialog( void );
	void pleaseTransfer( const QString &transferto );
	void getUri( void );
	void ringTimeout( void );
	void acceptCallTimeout( void );
	void hideCall( void );

private:
	QList<IncomingCall> receivedCalls;
	QList<IncomingCall> missedCalls;
	IncomingCall *incomingCall;
	void updateCallRegister( void );

	// Sip Stuff
	SipCall *call;
	SipCallMember *member;

	// Audio Stuff
	CallAudio *audio;

	int ringCount;
	QTimer *ringTimer;
	bool isRingingTone;
	QTimer *acceptCallTimer;
	int audio_fd;
	QString subject;

	// GUI Stuff
	QLabel *curstat;
	QLabel *curaudiostat;
	QPushButton *dial;
	QPushButton *hangup;
	QPushButton *holdbutton;
	QPushButton *transferbutton;
	QPushButton *hidebutton;
	KComboBox *remote;
	KCompletion *remotecomp;
	KCallTransfer *transfer;
	PhoneBook *phoneBook;
	bool hided;

	// State stuff
	enum CallState {
		PreDial,
		Calling,
		Connected,
		Called };
	CallState curstate;

	// Private functions
	void forceDisconnect( void );
	QString getUserPrefix( void );
};

class KInstantMessageWidget : public QDialog
{
	Q_OBJECT
public:
	KInstantMessageWidget( SipCall *initcall, QWidget *parent = 0, const char *name = 0 );
	~KInstantMessageWidget( void );
	void instantMessage( SipMessage *message );
	SipCall *getCall();
	QString getRemote();
	void setRemote( QString newremote );

private slots:
	void mClicked( void );
	void getUri( void );

private:
	QList<IncomingCall> receivedCalls;
	QList<IncomingCall> missedCalls;
	IncomingCall *incomingCall;

	// Sip Stuff
	SipCall *imcall;
	SipCallMember *member;

	// GUI Stuff
	QMultiLineEdit *status;
	QMultiLineEdit *mEdit;
	KComboBox *remote;
	KCompletion *remotecomp;
	KCallTransfer *transfer;
	PhoneBook *phoneBook;

	// Private functions
	QString getUserPrefix( void );
};


#endif // KCALLWIDGET_H_INCLUDED
