#include <stdio.h>
#include <stdlib.h>
#include <qtimer.h>
#include <kconfig.h>
#include <kmenubar.h>
#include <kglobal.h>
#include <kapp.h>
#include <klocale.h>
#include <dissipate2/sipuser.h>
#include <dissipate2/sipclient.h>
#include <dissipate2/sipcall.h>
#include <dissipate2/sipregister.h>
#include <callaudio.h>
#include <audiocontrol.h>
#include <ksipregistrations.h>
#include <kphoneview.h>
#include <ksipuserinfo.h>
#include <ksippreferences.h>
#include <ksipoptions.h>
#include <kphone.h>

KPhone::KPhone( unsigned int listenport, QString prefix, bool looseRoute, bool strictRoute ) : KMainWindow(0)
{
	SipUri uri;
	QString uristr;
	bool isDefaultUser;
	if( Sip::getLocalAddress().isEmpty() ) {
		exit(0);
	}
	userPrefix = "";
	if( !prefix.isEmpty() ) {
		setCaption( prefix );
		userPrefix = "_" + prefix + "_";
	}
	KConfig *config = KGlobal::config();
	Sip::setLocalAddress( config->readEntry( "dissipate_addr", Sip::getLocalAddress() ) );
	client = new SipClient( 0, 0, listenport, looseRoute, strictRoute );
	QString label = getUserPrefix() + "Registration";
	config->setGroup( label );
	uristr = config->readEntry( "SipUri" );
	if( uristr != QString::null ) {
		isDefaultUser = true;
		uri = SipUri( uristr );
	} else {
		isDefaultUser = false;
		uri = client->getContactUri();
	}
	if( config->readEntry( "UseProxyDial", "Yes" ) = "Yes" ) {
		client->setUseProxyDial( true );
	} else {
		client->setUseProxyDial( false );
	}
	
	client->setDefaultUserMode( config->readBoolEntry( "defusermode", true ) );
	client->setCallForward( config->readBoolEntry( "callforward", false ) );
	client->setCallForwardUri( SipUri( config->readEntry( "forwardaddr", QString::null ) ) );
	client->setCallForwardMessage( config->readEntry( "forwardmsg", QString::null ) );
	client->setMaxForwards( config->readNumEntry( "maxforwards", 0 ) );
	client->setBusyMessage( config->readEntry( "busymsg", QString::null ) );

	QString hvstr = config->readEntry( "hideviamode", "NoHide" );
	if( hvstr == "NoHide" ) { client->setHideViaMode( SipClient::DontHideVia ); }
	else if( hvstr == "HideHop" ) { client->setHideViaMode( SipClient::HideHop ); }
	else if( hvstr == "HideRoute" ) { client->setHideViaMode( SipClient::HideRoute ); }

	user = new SipUser( client, SipUri( uristr ) );
	client->setDefaultUser( user );

	audio = new CallAudio;
	audio->readAudioSettings();
	audio->readVideoSettings();

	// Initially, none of the dialogs exist yet
	qdial = 0;
	userinfo = 0;
	audiocontrol = 0;
	videocontrol = 0;
	registrations = 0;
	sipprefs = 0;
	queryoptions = 0;
	testoptions = 0;
	sipusers = 0;

	view = new KPhoneView( audio, client, user, this, getUserPrefix() );
	if( isDefaultUser ) {
		QString label = getUserPrefix() + "Registration";
		config->setGroup( label );
		QString userdefaultproxy = config->readEntry( "SipServer", QString::null );
		if( userdefaultproxy.lower() == "sip:" ) {
			userdefaultproxy = "";
		}
		view->updateIdentity( user );
		client->updateIdentity( user, userdefaultproxy );
	}
	registrations = new KSipRegistrations( client, view, this, getUserPrefix() );
	view->identities( registrations );

	setCentralWidget( view );

	QPopupMenu *popup = new QPopupMenu;
	popup->insertItem( "New Call...", view, SLOT( makeNewCall() ) );
	popup->insertItem( "New Video Call...", view, SLOT( makeVideoCall() ) );
	popup->insertItem( "Identity...", this, SLOT( showRegistrations() ) );

//#test
//	popup->insertItem( "Options...", this, SLOT( showQueryOptions() ) );
//	popup->insertItem( "Test...", this, SLOT( showTestOptions() ) );

	popup->insertSeparator();
	popup->insertItem( "&Quit", this, SLOT( kphoneQuit() ) );
	menuBar()->insertItem( "&File", popup );
	popup = new QPopupMenu;
	popup->insertItem( "SIP Preferences...", this, SLOT( showGlobalPreferences() ) );
	popup->insertItem( "Audio Preferences...", this, SLOT( showAudioPreferences() ) );
	popup->insertItem( "Video Preferences...", this, SLOT( showVideoPreferences() ) );
	popup->insertItem( "Phone Book", view, SLOT( showPhoneBook() ) );
	menuBar()->insertItem( "&Preferences", popup );
	menuBar()->insertSeparator();
	menuBar()->insertItem( "&Help",
		(QPopupMenu *)helpMenu( i18n( "The KDE Internet Phone\n\n"
				"(c) 1999 Billy Biggs\n\n"
				"KPhone ") + KPhoneVersion.latin1() + "\n"
				"(c) 2002 Wirlab\n"  ) );
	if( registrations->getUseStun() ) {
		audio->setStunSrv( registrations->getStunSrv() );
		client->sendStunRequest( registrations->getStunSrv() );
		QTimer *stun_timer = new QTimer( this );
		connect( stun_timer, SIGNAL( timeout() ), this, SLOT( stun_timerTick() ) );
		int timeout = config->readNumEntry( "RequestPeriod", constStunRequestPeriod );
		if( timeout > 0 ) {
			stun_timer->start( timeout * 1000 );
		}
	}
	QTimer *timer = new QTimer( this );
	connect( timer, SIGNAL( timeout() ), this, SLOT( timerTick() ) );
	timer->start( 1 );
	resize( 160, 250 );
}

KPhone::~KPhone( void )
{
	// This, apparently, never gets called.
	// At least not reliably.
}

void KPhone::saveProperties( KConfig * )
{
}

void KPhone::readProperties( KConfig * )
{
}

void KPhone::timerTick( void )
{
	client->doSelect( false );
}

void KPhone::stun_timerTick( void )
{
	client->sendStunRequest();
}

void KPhone::showUsers( void )
{
}

QString KPhone::getUserPrefix( void )
{
	return userPrefix;
}

void KPhone::showUserInfo( void )
{
}

void KPhone::showAudioPreferences( void )
{
	if( !audiocontrol ) {
		audiocontrol = new AudioControl( audio, this, getUserPrefix() );
	}
	audiocontrol->show();
}

void KPhone::showVideoPreferences( void )
{
	if( !videocontrol ) {
		videocontrol = new VideoControl( audio, this, getUserPrefix() );
	}
	videocontrol->show();
}

void KPhone::showRegistrations( void )
{
	registrations->showIdentity();
}

void KPhone::showGlobalPreferences( void )
{
	if( !sipprefs ) {
		sipprefs = new KSipPreferences( client, this, getUserPrefix() );
	}
	sipprefs->show();
}

void KPhone::showQueryOptions( void )
{
	if( !queryoptions ) {
		queryoptions = new KSipOptions( user );
	}
	queryoptions->show();
}

void KPhone::showTestOptions( void )
{
	if( !testoptions ) {
		testoptions = new KTestOptions( client );
	}
	client->setTest( true );
	testoptions->show();
}


void KPhone::kphoneQuit( void )
{
	view->kphoneQuit();
	quitTimer = new QTimer( this );
	connect( quitTimer, SIGNAL( timeout() ), kapp, SLOT( quit() ) );
	quitTimer->start( quitTime );
	hide();
}

void KPhone::closeEvent( QCloseEvent* ce )
{
	ce->ignore();
	kphoneQuit();
}

#include "kphone.moc"
