#ifndef KPHONE_H_INCLUDED
#define KPHONE_H_INCLUDED

#include <kmainwindow.h>

class SipClient;
class SipUser;
class PhoneList;
class CallAudio;
class AudioControl;
class VideoControl;
class KSipUserInfo;
class KConfig;
class KPhoneView;
class KSipRegistrations;
class KSipPreferences;
class KSipOptions;
class SipRegister;
class KSipUsers;
class KTestOptions;

QString const KPhoneVersion = "3.11";
int const quitTime = 5000;
int const ringTime_1 = 200;
int const ringTime_2 = 2000;
int const acceptTime = 500;
int const acceptSubscribeSendToSubscribe_time = 5000;
int const constRegistrationExpiresTime = 900;
int const constSubscribeExpiresTime = 600;
int const constStunRequestPeriod = 60;
int const kphoneMinimunWidht = 220;
QString const constStunServer = "stun.wirlab.net:3478";

class KPhone : public KMainWindow
{
	Q_OBJECT
public:
	KPhone( unsigned int listenport, QString prefix, bool looseRoute, bool strictRoute );
	~KPhone( void );
	void showUsers( void );
	QString getUserPrefix( void );

private slots:
	void timerTick( void );
	void stun_timerTick( void );
	void showUserInfo( void );
	void showAudioPreferences( void );
	void showVideoPreferences( void );
	void showRegistrations( void );
	void showGlobalPreferences( void );
	void showQueryOptions( void );
	void showTestOptions( void );
	void kphoneQuit( void );

protected:
	void closeEvent( QCloseEvent* );
	void saveProperties( KConfig * );
	void readProperties( KConfig * );
	KPhoneView *view;

	// Global state
	SipClient *client;
	SipUser *user;
	CallAudio *audio;

	// Dialogs
	PhoneList *qdial;
	KSipUserInfo *userinfo;
	AudioControl *audiocontrol;
	VideoControl *videocontrol;
	KSipRegistrations *registrations;
	KSipPreferences *sipprefs;
	KSipOptions *queryoptions;
	KSipUsers *sipusers;
	KTestOptions *testoptions;

private:
	QTimer *quitTimer;
	QString userPrefix;

};

#endif // KPHONE_H_INCLUDED
