#include <sys/time.h>
#include <qtimer.h>
#include <kphonetimer.h>

KPhoneTimer::KPhoneTimer( QWidget *parent, const char *name )
	: QLabel( parent, name )
{
	timer = new QTimer( this );
	connect( timer, SIGNAL( timeout() ), this, SLOT( timeout() ) );

	setAlignment( AlignRight );
	setText( "00:00 " );

	start_sec = 0;
}

KPhoneTimer::~KPhoneTimer( void )
{
}

void KPhoneTimer::startTimer( void )
{
	struct timeval tv;

	gettimeofday( &tv, NULL );
	start_sec = tv.tv_sec;

	timer->start( 500 );
}

void KPhoneTimer::continueTimer( void )
{
	timer->start( 500 );
}

void KPhoneTimer::stopTimer( void )
{
	timer->stop();
}

void KPhoneTimer::timeout( void )
{
	struct timeval tv;
	QString text;

	gettimeofday( &tv, NULL );

	text.sprintf( "%02ld:%02ld ", ( tv.tv_sec - start_sec ) / 60, ( tv.tv_sec - start_sec ) % 60 );

	setText( text );
}

#include "kphonetimer.moc"
