#ifndef KPHONEVIEW_H_INCLUDED
#define KPHONEVIEW_H_INCLUDED

#include <qwidget.h>
#include <qptrdict.h>
#include <kdialogbase.h>
#include <dissipate2/sipuri.h>
#include <qradiobutton.h>
#include <qxml.h>
#include <qstack.h>


class SipClient;
class SipUser;
class SipCall;
class SipCallMember;
class KCallWidget;
class KInstantMessageWidget;
class QListViewItem;
class CallAudio;
class KPhone;
class KSipRegistrations;
class ContactsListView;


class ContactParser : public QXmlDefaultHandler
{
public:
	ContactParser( void );
	bool startDocument();
	bool startElement( const QString&, const QString&, const QString&, const QXmlAttributes& );
	bool endElement( const QString&, const QString&, const QString& );
	QStringList getListContacts( void ) { return contacts; }
private:
	QStringList contacts;
};

class KPhoneView : public QWidget
{
	Q_OBJECT
public:
	enum State { ONLINE, OFFLINE };
	KPhoneView( CallAudio *callaudio, SipClient *c, SipUser *u, QWidget *parent = 0, const char *name = 0 );
	~KPhoneView( void );
	void switchCall( SipCall *call );
	void updateIdentity( SipUser *newUser, SipRegister *newReg = 0 );
	void identities( KSipRegistrations *i );
	void updateContacts( QString file );
	void setContactsOffline( void );
	void setContactsOnline( void );
	void kphoneQuit( void );

public slots:
	void makeNewCall( void );
	void makeVideoCall( void );
	void redirectCall( const SipUri &calluri, const QString &subject );
	void showIdentities( void );
	void localStatusUpdate( void );
	void stateUpdated( int id );
	void updateSubscribes( void );

private slots:
	void incomingInstantMessage( SipMessage *message );
	void incomingSubscribe( SipCallMember *member, bool sendSubscribe );
	void incomingCall( SipCall *call, QString body );
	void hideCallWidget( SipCall *call );
	void contactDoubleClicked( QListViewItem *i );
	void busyToggled( bool onoff );
	void contactSendMessage();
	void contactCall( void );
	void contactVideoCall( void );
	void showPhoneBook( void );
	void buttonOffOnlineClicked( void );
	void buttonUpdateClicked( void );

protected:
	SipClient *client;
	SipUser *user;
	ContactsListView *clist;
	int callcount;
	QPushButton *buttonSipUri;
	QPushButton *buttonNewCall;
	QPushButton *buttonVideoCall;
	QLineEdit *lineeditCall;
	QLabel *labelSipUri;
	QLabel *labelFullname;
	KPhone *kphone;
	KSipRegistrations *identitiesDialog;

private:
	void sendNotify( int id, SipCallMember *member = 0 );
	QString getUserPrefix( void );
	void saveRejectContactList( void );
	QList<KCallWidget> cwList;
	QList<KInstantMessageWidget> imwList;
	QStringList rejectedContactList;
	void saveContacts( void );
	void addContactToPhoneBook( SipCallMember *member );
	SipRegister *reg;
	QPushButton *buttonOffOnline;
	QPushButton *buttonUpdate;
	QLineEdit *lineeditState;
	int atomId;
	QTimer *subscribeTimer;
	int subscribeExpiresTime;
	CallAudio *callAudio;
	bool isOnline;
	bool buttonSetOffline;
	bool setSubscribeOffline;
	void updateWidgetList( void );
};

#endif // KPHONEVIEW_H_INCLUDED
