#include <qvbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qdir.h>
#include <qhbuttongroup.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qmultilineedit.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <dissipate2/sipprotocol.h>
#include <dissipate2/sipclient.h>
#include <kphone.h>
#include <ksippreferences.h>

KSipPreferences::KSipPreferences( SipClient *client, QWidget *parent, const char *name )
	: KDialogBase( KDialogBase::Tabbed, QString( name ) + "Global SIP Preferences", Ok|Apply|Cancel, Ok, parent, name, false, true )
{
	c = client;
	QVBox *vboxadv = addVBoxPage( i18n("Settings") );

	// Via hiding radio buttons
	hidebg = new QHButtonGroup( i18n("Hide Via"), vboxadv );
	QRadioButton *nohide = new QRadioButton( i18n("Don't Hide"), hidebg );
	hidebg->insert( nohide, NoHide );
	QRadioButton *hophide = new QRadioButton( i18n("Request Next Hop"), hidebg );
	hidebg->insert( hophide, HideHop );

	QRadioButton *routehide = new QRadioButton( i18n("Request Full Route"), hidebg );
	hidebg->insert( routehide, HideRoute );

	// Set max forwards
	(void) new QLabel( i18n("Max Forwards"), vboxadv );
	maxforwards = new QLineEdit( vboxadv );

	// PhoneBook
	(void) new QLabel( i18n("XML-File for Phone Book:"), vboxadv );
	phonebook = new QLineEdit( vboxadv );

	// RegistrationExpiresTime
	(void) new QLabel( i18n("Expire Time of Registration (second):"), vboxadv );
	expires = new QLineEdit( vboxadv );

	// SubscribeExpiresTime
	(void) new QLabel( i18n("Expire Time of Presence Subscription (second):"), vboxadv );
	subscribeExpires = new QLineEdit( vboxadv );

	// Socket
	QVBox *vboxs = addVBoxPage( i18n("Socket") );

	// UDP / TCP
	socket = new QHButtonGroup( i18n("Socket Protocol (Kphone restart needed to apply change)"), vboxs );

	QRadioButton *udp = new QRadioButton( i18n("UDP"), socket );
	socket->insert( udp, UDP );

	QRadioButton *tcp = new QRadioButton( i18n("TCP"), socket );
	socket->insert( tcp, TCP );

	// STUN
	stun = new QHButtonGroup( i18n("Use STUN Server"), vboxs );
	QRadioButton *StunYes = new QRadioButton( i18n("Yes"), stun );
	stun->insert( StunYes, stunYes );
	QRadioButton *StunNo = new QRadioButton( i18n("No"), stun );
	stun->insert( StunNo, stunNo );
	(void) new QLabel( i18n("STUN Server (address:port):"), vboxs );
	stunServerAddr = new QLineEdit( vboxs );

	// Request period
	(void) new QLabel( i18n("Request Period for STUN Server (second):"), vboxs );
	stunRequestPeriod = new QLineEdit( vboxs );

	// Call Preferences
	QVBox *vboxprefs = addVBoxPage(i18n("Call Preferences"));

	// Default user mode
	usedef = new QHButtonGroup(i18n("Policy for Unknown Incoming URIs"), vboxprefs );

	QRadioButton *defmode = new QRadioButton(i18n("Accept"), usedef );
	usedef->insert( defmode, DefMode );

	QRadioButton *nodefmode = new QRadioButton(i18n("Reject with Not Found"), usedef );
	usedef->insert( nodefmode, NoDefMode );

	// Busy message
	(void) new QLabel(i18n("Busy Message:"), vboxprefs );
	busymsg = new QMultiLineEdit( vboxprefs );

	// Call Forwarding
	QVBox *vboxfor = addVBoxPage(i18n("Call Forwarding") );

	forbg = new QHButtonGroup(i18n("Call Forwarding"), vboxfor );

	QRadioButton *nocforward = new QRadioButton( i18n("Inactive"), forbg );
	forbg->insert( nocforward, FwInactive );

	QRadioButton *cforward = new QRadioButton( i18n("Active"), forbg );
	forbg->insert( cforward, FwActive );

	// Forward to Uri
	(void) new QLabel( i18n("Forward to:"), vboxfor );
	forwardaddr = new QLineEdit( vboxfor );

	// Forward to message
	(void) new QLabel( i18n("Call Forward Message:"), vboxfor );
	forwardmsg = new QMultiLineEdit( vboxfor );

	resetSettings();
}

KSipPreferences::~KSipPreferences( void )
{
}

void KSipPreferences::slotOk( void )
{
	slotApply();
	QDialog::accept();
}

void KSipPreferences::slotApply( void )
{
	switch( hidebg->id( hidebg->selected() ) ) {
		case HideHop:
			c->setHideViaMode( SipClient::HideHop );
			break;
		case HideRoute:
			c->setHideViaMode( SipClient::HideRoute );
			break;
		default:
		case NoHide:
			c->setHideViaMode( SipClient::DontHideVia );
			break;
	}
	if( usedef->id( usedef->selected() ) == DefMode ) {
		c->setDefaultUserMode( true );
	} else {
		c->setDefaultUserMode( false );
	}
	if( forbg->id( forbg->selected() ) == FwActive ) {
		c->setCallForward( true );
	} else {
		c->setCallForward( false );
	}

	c->setCallForwardUri( SipUri( forwardaddr->text() ) );
	c->setCallForwardMessage( forwardmsg->text() );
	c->setMaxForwards( maxforwards->text().toUInt() );
	c->setBusyMessage( busymsg->text() );

	KConfig *config = KGlobal::config();
	config->setGroup( "SIP" );

	config->writeEntry( "defusermode", c->getDefaultUserMode() );
	config->writeEntry( "callforward", c->getCallForward() );
	config->writeEntry( "forwardaddr", c->getCallForwardUri().nameAddr() );
	config->writeEntry( "forwardmsg", c->getCallForwardMessage() );
	config->writeEntry( "maxforwards", c->getMaxForwards() );
	config->writeEntry( "busymsg", c->getBusyMessage() );

	QString hvstr;
	switch( c->getHideViaMode() ) {
		default:
		case SipClient::DontHideVia: hvstr = "NoHide"; break;
		case SipClient::HideHop: hvstr = "HideHop"; break;
		case SipClient::HideRoute: hvstr = "HideRoute"; break;
	}
	config->writeEntry( "hideviamode", hvstr );

	QString label = ((KPhone *)parentWidget())->getUserPrefix() + "Local";
	config->setGroup( label );
	config->writeEntry( "PhoneBook", phonebook->text() );
	if( expires->text() ) {
		config->writeEntry( "RegistrationExpiresTime", expires->text() );
	}
	if( subscribeExpires->text() ) {
		bool ok;
		int dec = subscribeExpires->text().toInt( &ok, 10 );
		if( ok ) {
			if( dec < 60 ) {
				subscribeExpires->setText( "60" );
			}
			config->writeEntry( "SubscribeExpiresTime", subscribeExpires->text() );
		}
	}
	config->setGroup( "General" );
	switch( socket->id( socket->selected() ) ) {
		case TCP:
			config->writeEntry( "SocketMode", "TCP" );
			break;
		default:
			config->writeEntry( "SocketMode", "UDP" );
			break;
	}

	config->setGroup( "STUN" );
	config->writeEntry( "StunServer", stunServerAddr->text() );
	config->writeEntry( "RequestPeriod", stunRequestPeriod->text() );
	switch( stun->id( stun->selected() ) ) {
		case stunYes:
			config->writeEntry( "UseStun", "Yes" );
			break;
		default:
			config->writeEntry( "UseStun", "No" );
			break;
	}

	config->sync();
}

void KSipPreferences::slotCancel( void )
{
	resetSettings();
	QDialog::reject();
}

void KSipPreferences::resetSettings( void )
{
	forwardaddr->setText( c->getCallForwardUri().nameAddr() );
	forwardmsg->setText( c->getCallForwardMessage() );
	maxforwards->setText( QString::number( c->getMaxForwards() ) );
	busymsg->setText( c->getBusyMessage() );

	switch( c->getHideViaMode() ) {
		default:
		case SipClient::DontHideVia: hidebg->setButton( NoHide ); break;
		case SipClient::HideHop: hidebg->setButton( HideHop ); break;
		case SipClient::HideRoute: hidebg->setButton( HideRoute ); break;
	}

	if( c->getDefaultUserMode() ) {
		usedef->setButton( DefMode );
	} else {
		usedef->setButton( NoDefMode );
	}

	if( c->getCallForward() ) {
		forbg->setButton( FwActive );
	} else {
		forbg->setButton( FwInactive );
	}

	KConfig *config = KGlobal::config();

	QString label = ((KPhone *)parentWidget())->getUserPrefix() + "Local";
	config->setGroup( label );
	QString xmlFile = config->readEntry( "PhoneBook", "" );
	if( xmlFile.isEmpty() ) {
		if( ((KPhone *)parentWidget())->getUserPrefix().isEmpty() ) {
			xmlFile = QDir::homeDirPath() + "/.kphone-phonebook.xml";
		} else {
			xmlFile = QDir::homeDirPath() + "/.kphone" + ((KPhone *)parentWidget())->getUserPrefix() + "phonebook.xml";
		}
	}
	phonebook->setText( xmlFile );
	QString strDefault;
	expires->setText( config->readEntry( "RegistrationExpiresTime", strDefault.setNum( constRegistrationExpiresTime ) ) );
	subscribeExpires->setText( config->readEntry( "SubscribeExpiresTime", strDefault.setNum( constSubscribeExpiresTime ) ) );

	config->setGroup( "STUN" );
	if( config->readEntry( "UseStun", "No" ) == "Yes" ) {
		stun->setButton( stunYes );
	} else {
		stun->setButton( stunNo );
	}
	stunServerAddr->setText( config->readEntry( "StunServer", constStunServer ) );
	stunRequestPeriod->setText( config->readEntry( "RequestPeriod", strDefault.setNum( constStunRequestPeriod ) ) );

	if( c->isTcpSocket() ) {
		socket->setButton( TCP );
	} else {
		socket->setButton( UDP );
	}
}

#include "ksippreferences.moc"
