#ifndef KSIPPREFERENCES_H_INCLUDED
#define KSIPPREFERENCES_H_INCLUDED

#include <kdialogbase.h>

class SipClient;
class QLineEdit;
class QMultiLineEdit;
class QButtonGroup;

class KSipPreferences : public KDialogBase
{
	Q_OBJECT
public:
	KSipPreferences( SipClient *client, QWidget *parent = 0, const char *name = 0 );
	~KSipPreferences( void );

protected slots:
	void slotOk( void );
	void slotApply( void );
	void slotCancel( void );
	void resetSettings( void );

private:
	enum ExpProxy { DontUseExpProxy, UseExpProxy };
	enum HideVia { NoHide, HideHop, HideRoute };
	enum DefUserMode { DefMode, NoDefMode };
	enum CallForward { FwActive, FwInactive };
	enum Socket { UDP, TCP };
	enum Stun { stunYes, stunNo };

	SipClient *c;
	QLineEdit *proxyaddr;
	QLineEdit *forwardaddr;
	QLineEdit *maxforwards;
	QLineEdit *phonebook;
	QLineEdit *expires;
	QLineEdit *subscribeExpires;
	QLineEdit *stunServerAddr;
	QLineEdit *stunRequestPeriod;
	QMultiLineEdit *forwardmsg;
	QMultiLineEdit *busymsg;
	QButtonGroup *expbg;
	QButtonGroup *hidebg;
	QButtonGroup *usedef;
	QButtonGroup *forbg;
	QButtonGroup *stun;
	QButtonGroup *socket;
};

#endif // KSIPPREFERENCES_H_INCLUDED
