#ifndef KSIPUSERINFO_H_INCLUDED
#define KSIPUSERINFO_H_INCLUDED

#include <qdatetime.h>
#include <qdialog.h>
#include <qptrdict.h>
#include <kdialogbase.h>
#include <qxml.h>
#include <qstack.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <dissipate2/sipcall.h>
#include <menulistview.h>

class QListView;
class QListViewItem;
class QString;
class QPushButton;


class IncomingCall
{
public:
	IncomingCall( QString s, QDateTime time );
	~IncomingCall( void );
	QString getContact( void ) const { return contact; }
	QDateTime getDateTime( void ) const { return dt; }
private:
	QString contact;
	QDateTime dt;
};


class PhoneBookAddIdentity : public KDialogBase
{
	Q_OBJECT
public:
	PhoneBookAddIdentity( QWidget *parent = 0, const char *name = 0 );
	void clean( void );
	void setPerson( QString );
	void setIdentity( QString );
	void setDescription( QString );
	void setContact( bool );
	QString getIdentity( void );
	QString getDescription( void );
	QString getPerson( void );
	QString getContact( void );
signals:
	void done( void );
	void update( void );
protected slots:
	void slotOk( void );
	void slotCancel( void );
private:
	QLineEdit *identity;
	QLineEdit *description;
	QLineEdit *person;
	QCheckBox *contact;
};


class PhoneBookEditIdentity : public KDialogBase
{
	Q_OBJECT
public:
	PhoneBookEditIdentity( QWidget *parent = 0, const char *name = 0 );
	~PhoneBookEditIdentity( void );
	QString getIdentity( void );
	QString getDescription( void );
	QString getContact( void );
	void setIdentity( QString );
	void setDescription( QString );
	void setContact( QString );
signals:
	void done( void );
	void update( void );
protected slots:
	void slotOk( void );
	void slotCancel( void );
private:
	QLineEdit *identity;
	QLineEdit *description;
	QCheckBox *contact;
};


class PhoneBookEditPerson : public KDialogBase
{
	Q_OBJECT
public:
	PhoneBookEditPerson( QWidget *parent = 0, const char *name = 0 );
	~PhoneBookEditPerson( void );
	QString getPerson( void );
	void setPerson( QString );
signals:
	void done( void );
	void update( void );
protected slots:
	void slotOk( void );
	void slotCancel( void );
private:
	QLineEdit *person;
};

class PhoneBookParser : public QXmlDefaultHandler
{
public:
	PhoneBookParser( QListView * t, bool CallRegister = true, bool rejectedContact = false );
	bool startDocument();
	bool startElement( const QString&, const QString&, const QString&, const QXmlAttributes& );
	bool endElement( const QString&, const QString&, const QString& );
	QListViewItem *getListPhoneBook( void ) { return listPhoneBook; }
	QListViewItem *getListReceivedCalls( void ) { return listReceivedCalls; }
	QListViewItem *getListMissedCalls( void ) { return listMissedCalls; }
	QListViewItem *getRejectedContacts( void ) { return rejected; }
private:
	QStack<QListViewItem> stack;
	QListViewItem *rejected;
	QListViewItem *listPhoneBook;
	QListViewItem *listReceivedCalls;
	QListViewItem *listMissedCalls;
};

class PhoneBook : public QDialog
{
	Q_OBJECT
public:
	PhoneBook( QString fileUserInfo, QWidget *parent, const char *name ,
			QList<IncomingCall> &receivedCalls, QList<IncomingCall> &missedCalls,
			QStringList &rejectedContacts );
	~PhoneBook( void );
	void addContact( SipCallMember *member );
	QStringList getRejectedContactsList();
private slots:
	bool setIdentity( QListViewItem * );
	void setIdentityAndDone( QListViewItem * );
	void clickAddButton( void );
	void clickEditButton( void );
	void clickRemoveButton( void );
	void clickHideButton( void );
public slots:
	QString getUri();
private:
	void save( void );
	QString clean( QString s );
	MenuListView *phoneBook;
	QPushButton *add_button;
	QPushButton *edit_button;
	QPushButton *remove_button;
	QPushButton *save_button;
	QString remote;
	PhoneBookAddIdentity *addIdentity;
	PhoneBookEditIdentity *editIdentity;
	PhoneBookEditPerson *editPerson;
	QString filePhoneBook;
	PhoneBookParser *parser;
	QString caption;
};

#endif // KSIPUSERINFO_H_INCLUDED
