#include <kapp.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kphone.h>

int main( int argc, char **argv )
{
	KAboutData aboutData( "kphone", I18N_NOOP("KPhone"),
		KPhoneVersion.latin1(), "KDE IP Phone", KAboutData::License_GPL,
		"(c) 1999-2000, Billy Biggs; (c) 2002, Wirlab" );
	KCmdLineArgs::init( argc, argv, &aboutData );
	static KCmdLineOptions options[] = {
		{ "u <argument>", I18N_NOOP("User"), 0 },
		{ "p <argument>", I18N_NOOP("Listen Port"), 0 },
		{ "s", I18N_NOOP("Strict Route"), 0 },
		{ "l", I18N_NOOP("Loose Route"), 0 }
	};
	int listenport = 0;
	QString user = "";
	KCmdLineArgs::addCmdLineOptions( options );
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs( );
	listenport = QString( args->getOption( "p" ) ).toInt();
	user = args->getOption( "u" );
	bool looseRoute = args->isSet( "l" );
	bool strictRoute = args->isSet( "s" );

	KApplication a;
	KPhone *phone = new KPhone( listenport, user, looseRoute, strictRoute );
	phone->show();
	return a.exec();
}
