#include <menulistview.h>

MenuListView::MenuListView( QWidget *parent, const char *name )
	: QListView( parent, name )
{
	connect( this, SIGNAL( rightButtonPressed( QListViewItem *, const QPoint&, int ) ),
			this, SLOT( showMenu( QListViewItem *, const QPoint&, int ) ) );

	ops = new QPopupMenu( this );
}

MenuListView::~MenuListView( void )
{
}

void MenuListView::addMenuItem( QString desc, const QObject *reciever, const char *member )
{
	ops->insertItem( desc, reciever, member );
}

void MenuListView::addMenuSeparator( void )
{
	ops->insertSeparator();
}

void MenuListView::showMenu( QListViewItem *curi, const QPoint& pos, int )
{
	setCurrentItem( curi );
	setSelected( curi, TRUE );
	ops->popup( pos );
}

#include "menulistview.moc"
