
/*
 * compat.cc
 * Copyright (C) 2000 by John Heidemann
 * $Id: compat.cc,v 1.4 2000/06/02 00:43:01 johnh Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 */


#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>  // for snprintf

#include "compat.hh"

#ifndef HAVE_SETENV
int
setenv(const char *name, const char *value, int overwrite)
{
	char buf[256];
	snprintf(buf, sizeof(buf), "DISPLAY=%s", value);
	return putenv(buf);
}
#endif /* ! HAVE_SETENV */


#ifndef HAVE_SNPRINTF
/*
 * This implementation maps overflow into a hard failure.
 */
int
snprintf(char *buf, int size, const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);

	/* can't assume vsprintf returns len, since sunos returns char* */
	vsprintf(buf, fmt, ap);
	if (strlen(buf) >= size)
		abort();
	return n;
}
#endif /* HAVE_SNPRINTF */
