
/*
 * main.h
 * Copyright (C) 1999-2000 by John Heidemann
 * $Id: main.hh,v 1.22 2000/02/18 06:54:17 johnh Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 */

extern void die(char *s);
extern int lava_random(int range);
inline int sign(int a) { return (a < 0) ? -1 : ((a > 0) ? 1 : 0); }

extern "C" {
extern const char *hsb_to_rgbs(double H, double S, double B);
}

#include <string>

#include "config.h"
#include "compat.hh"

#include "entry_trace.hh"

#include "change_tracking.hh"

extern int filter_good_uid,
	filter_good_pid;
extern bool allow_autosize,
	lava_debug;
enum proc_filter_style_enum { FILTER_ERROR, FILTER_BY_PID, FILTER_BY_UID, FILTER_NOTHING };
extern proc_filter_style_enum filter_style;
enum vm_style_enum { ERROR_MEM, VIRTUAL_MEM, PHYSICAL_MEM, BOTH_MEM };
extern change_tracking<vm_style_enum> report_vm;
extern string default_resources;

// pedantic_assert is really just to document conditions
// (while I expect asserts to run at runtime)
#define pedantic_assert(X)
