
// See white point


#include "lcms.h"


static
double f(double t)
{

       if (t <= 0.008856)
                     return 7.787*t + (16./116.);
       else
                     return pow(t, 1.0/3.0);

}

static
void XYZ2Lab(double X, double Y, double Z, double *L, double *a, double *b)
{
       double x, y, z;
       double fx, fy, fz;



       if (X==0 && Y==0 && Z==0) {

                     *L = 0;
                     *a = *b = -1;
                     return;
       }

       // PCS is in D50


       x = (X) / 0.964294;
       y = (Y);
       z = (Z) / 0.825104;


       fx = f(x);
       fy = f(y);
       fz = f(z);

       *L = 116.* fy - 16.;

       *a = 500.*(fx - fy);
       *b = 200.*(fy - fz);

}



static
void XYZ2xyY(LPcmsCIExyY Dest, CONST LPcmsCIEXYZ Source)
{
       double ISum;

       ISum = 1./(Source -> X + Source -> Y + Source -> Z);

       Dest -> x = (Source -> X) * ISum;
       Dest -> y = (Source -> Y) * ISum;
       Dest -> Y = Source -> Y;
}


static
BOOL InRange(LPcmsCIExyY a, LPcmsCIExyY b, double tolerance)
{
       double dist_x, dist_y;

       dist_x = fabs(a->x - b->x);
       dist_y = fabs(a->y - b->y);

       return (tolerance >= dist_x * dist_x + dist_y * dist_y);

}


typedef struct {
                char Name[30];
                cmsCIExyY Val;

              } WHITEPOINTS;


static
int FromD50toD150(WHITEPOINTS* pts)
{
       int i, n;

       n = 0;


       for (i=50; i < 150; i ++)
       {
              sprintf(pts[n].Name, "D%d", i);
              cmsWhitePointFromTemp(i*100.0, &pts[n].Val);
              n++;
       }

   return n;
}

static
BOOL IdentifyWhitePoint(LPcmsCIEXYZ WhitePt)
{
       int i, n;
       cmsCIExyY Val;
       WHITEPOINTS SomeIlluminants[200] =
                                   {
                                   {"CIE illuminant A", {0.4476, 0.4074, 1.0}},
                                   {"CIE illuminant C", {0.3101, 0.3162, 1.0}}

                                   // {"D50", {0.3457, 0.3585, 1.0}},
                                   // {"D55", {0.3324, 0.3474, 1.0}},
                                   // {"D65", {0.3127, 0.3290, 1.0}},
                                   //{"D75", {0.2990, 0.3149, 1.0}}
                                   };

              n = FromD50toD150(&SomeIlluminants[2]) + 2;

              XYZ2xyY(&Val, WhitePt);

              for (i=0; i < n; i++)
              {


                            if (InRange(&Val, &SomeIlluminants[i].Val, 0.000005))
                            {
                                printf("WhitePoint : %s\n", SomeIlluminants[i].Name);
                                return TRUE;
                            }
              }



              printf("White point : (X:%2.2f, Y:%2.2f, Z:%2.2f) xy=(%3.3f, %3.3f)\n",
                                          WhitePt -> X, WhitePt -> Y, WhitePt -> Z, Val.x, Val.y);
              return FALSE;
}




static
void ShowWhitePoint(const char *cProfile)
{
       cmsHPROFILE hProfile;
       cmsCIEXYZ WtPt;
       double L, a, b;

       hProfile = cmsOpenProfileFromFile(cProfile, "r");

       printf("%s\n", cmsTakeProductName(hProfile));

       cmsTakeMediaWhitePoint(&WtPt, hProfile);

       if (!IdentifyWhitePoint(&WtPt))
       {
              // cannot be identified...

              XYZ2Lab(WtPt.X, WtPt.Y, WtPt.Z, &L, &a, &b);
              printf("\t\tLab=(%3f,%3.3f,%3.3f) ", L, a, b);

              printf("hue=%3f, Chroma=%3f\n", atan2(b, a), sqrt(a*a + b*b));
       }

       printf("\n");
       cmsCloseProfile(hProfile);
}


int main (int argc, char *argv[])
{
       printf("Show media white of profiles, identifying black body locus\n\n");


       if (argc == 2) {


              ShowWhitePoint(argv[1]);
              }
       else
              {
              cmsCIEXYZ xyz;
              cmsCIExyY xyY;
              printf("usage:\n\nIf no parameters are given, then this program will\n");
              printf("ask for XYZ value of media white. If parameter given, it must be\n");
              printf("the profile to inspect.\n\n");

              printf("X? "); scanf("%lf", &xyz.X);
              printf("Y? "); scanf("%lf", &xyz.Y);
              printf("Z? "); scanf("%lf", &xyz.Z);

              cmsXYZ2xyY(&xyY, &xyz);
              printf("xyY=%g, %g, %g\n", xyY.x, xyY.y, xyY.Y);

              printf("XYZ=(%g,%g,%g)\n", xyz.X, xyz.Y,xyz.Z);
              IdentifyWhitePoint(&xyz);
              }

              return 0;
}

