
/* Little cms */
/* Copyright (C) 1998-2000 Marti Maria */

/* THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, */
/* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY */
/* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. */

/* IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL, */
/* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, */
/* OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, */
/* WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF */
/* LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE */
/* OF THIS SOFTWARE. */


/* This library is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU Lesser General Public */
/* License as published by the Free Software Foundation; either */
/* version 2 of the License, or (at your option) any later version. */

/* This library is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU */
/* Lesser General Public License for more details. */

/* You should have received a copy of the GNU Lesser General Public */
/* License along with this library; if not, write to the Free Software */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include "lcms.h"


/*
Gamut check by default is an catching of 0xFFFF/0xFFFF/0xFFFF PCS values, used
internally by lcms to hold invalid values. Matrix LUT's, operates in a way that
unencodeable values are marked as this combination, if PCS is XYZ, this is a very
high value since encoding is a 1.15 fixed point, something like 1.9997, 1.9997, 1.9997
a not very common color after all. Lab PCS is not to be a problem, since L>100 are truely
undefined. There is a posibility than ICC comitee defines L>100 as a valid means
to use highlights, but then, it also will be out of gamut such values.
*/


BOOL _cmsEndPointsBySpace(icColorSpaceSignature Space, WORD **White, WORD **Black,
                            int *nOutputs)
{
       /* Only most common spaces */

       static WORD RGBblack[4]  = { 0, 0, 0 };
       static WORD RGBwhite[4]  = { 0xffff, 0xffff, 0xffff };
       static WORD CMYKblack[4] = { 0, 0, 0, 0xffff };
       static WORD CMYKwhite[4] = { 0, 0, 0, 0 };
       static WORD LABblack[4]  = { 0, 0, 0 };
       static WORD LABwhite[4]  = { 0xFF00, 0x8000, 0x8000 };


       switch (Space) {

       case icSigRgbData:  *White = RGBwhite;
                           *Black = RGBblack;
                           *nOutputs = 3;
                           return TRUE;

       case icSigLabData:  *White = LABwhite;
                           *Black = LABblack;
                           *nOutputs = 3;
                           return TRUE;

       case icSigCmykData: *White = CMYKwhite;
                           *Black = CMYKblack;
                           *nOutputs = 4;
                           return TRUE;

       default:;
       }

  return FALSE;
}


WORD *_cmsWhiteBySpace(icColorSpaceSignature Space)
{
       WORD *White, *Black;
       int Dummy;
       static WORD Default[MAXCHANNELS];

       if (_cmsEndPointsBySpace(Space, &White, &Black, &Dummy))
              return White;

       return Default;

}


WORD Clamp_XYZ(int in)
{
       if (in < 0) return 0;
       if (in > 0xFFFF) return 0xFFFFU;   /* Including marker */
       return (WORD) in;
}

WORD Clamp_RGB(int in)
{
       if (in < 0) return 0;
       if (in > 0xFFFF) return 0xFFFFU;   /* Including marker */
       return (WORD) in;
}


WORD Clamp_L(Fixed32 in)
{
       if (in == 0xFFFFU) return 0xFFFFU;            /* Marker */

       if (in > 0xFF00U) return 0xFF00U;             /* L* = 100.0 */
       return (WORD) in;
}


#define ENCODE_AB(x) (WORD) (((x) + 128.0) * 256.0 + 0.5)

WORD Clamp_ab(Fixed32 in)
{
       if (in == 0xFFFFU) return 0xFFFFU;            /* Marker */

       if (in < 0) return ENCODE_AB(-128.0);         /* 0;         // Max negative number */
       if (in > 0xFFFF) return ENCODE_AB(+127.9961); /* 0xFFFF;    // Max positive number */
       return (WORD) in;
}


