'\"
'\" Copyright (c) 2000 Andreas Kupries
'\" All right reserved
'\"
'\" CVS: $Id$ ezdo.n
'\"
.so man.macros
.TH "ezdo" n 1.0 ezdo "Easy Do Command"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
ezdo \- Perform a specific task on a Cisco device.
.SH "SYNOPSIS"
package require \fBlibcisco\fR
.sp
\fBezdo savecfg\fR ?options? ?SessionId?\fR
.sp
\fBezdo clearcntrs\fR ?SessionId?\fR
.sp
\fBezdo debug\fR ?SessionId? \fIArgs\fR\fR
.sp
\fBezdo undebug\fR ?SessionId? \fIArgs\fR\fR
.sp
.BE
.SH "DESCRIPTION"
The \fBezdo\fR command is used to perform a specifc task on Cisco
devices.
.P
The first argument to \fBezdo\fR specifies the task to be performed
on the target device.  A list of valid tasks and their associated options
is detailed below.
.sp
.sp
Note: Before making a call to \fBezdo\fR, a session must first be opened
to the target device using the \fBsession open\fR command.
.P
.TP
\fBezdo savecfg\fR ?options? ?SessionId?\fR
Saves the configuration in RAM to NVRAM \fIif\fR the configuration
has been changed by any of the commands within this package.
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
The following options are supported:
.sp
.sp
\fB-force\fR
.sp
\fB--\fR (end of options)
.sp
.sp
The \fB-force\fR option will force this function to save the config
regardless of whether or not a configuration change has been made by any
of the commands in this package.  This effectively overrides the default
logic which causes this function to save the config \fIonly if\fR a
the configuration has been changed by a command in this package.
.sp
.sp
On success, \fBezdo savecfg\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBezdo clearcntrs\fR ?SessionId?\fR
Clears all counters on the target system.
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
On success, \fBezdo clearcntrs\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBezdo debug\fR ?SessionId? \fIArgs\fR\fR
Enable debugging on the target device. (IOS only)
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
\fIArgs\fR is one or more arguments to be concatenated together and
evaluated on the target system as a debug command.
.sp
.sp
On success, \fBezdo debug\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBezdo undebug\fR ?SessionId? \fIArgs\fR\fR
Disable debugging on the target device. (IOS only)
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
\fIArgs\fR is one or more arguments to be concatenated together and
evaluated on the target system as an undebug command.
.sp
.sp
On success, \fBezdo undebug\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.P
.SH "EXAMPLE"
The following code will open a session to 192.168.1.1, put the device in
"enable" mode, and clear the counters
.P
.RS
session open 192.168.1.1 cisco
.br
session enable san-fran
.br
ezdo clearcntrs
.br
session close
.br
.RE
.SH "SEE ALSO"
\fBsession\fR(n), \fBezset\fR(n), \fBezget\fR(n)
.SH "KEYWORDS"
ezdo, clear, counters, save, config

