'\"
'\" Copyright (c) 2000 Andreas Kupries
'\" All right reserved
'\"
'\" CVS: $Id$ ezget.n
'\"
.so man.macros
.TH "ezget" n 1.0 ezget "Easy Get Command"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
ezget \- Get information from a Cisco device.
.SH "SYNOPSIS"
package require \fBlibcisco\fR
.sp
\fBezget config\fR ?SessionId? \fIConfigType\fR\fR
.sp
.BE
.SH "DESCRIPTION"
The \fBezget\fR command is used to get information from Cisco devices.
.P
The first argument to \fBezget\fR specifies the type of information to get from
the target device.  A list of valid information elements and their associated
options is detailed below.
.sp
.sp
Note: Before making a call to \fBezget\fR, a session must first be opened
to the target device using the \fBsession open\fR command.
.P
.TP
\fBezget config\fR ?SessionId? \fIConfigType\fR\fR
Get the configuration from the target device.
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
\fIConfigType\fR may be one of two options--\fBprimary\fR or
\fBsecondary\fR.  The \fBprimary\fR option will cause the command to
get the running-config from an IOS device, the complete config of a switch
running Catalyst code, and the complete configuration of a 1900.  The
\fBsecondary\fR option will cause the function to retrieve the
startup-config from an IOS device, the nondefault config from a switch
running Catalyst code, and nothing from a 1900.
.sp
.sp
On success, \fBezget config\fR returns the configuration.
On error, a short text message is returned beginning with the string "err".
.P
.SH "EXAMPLE"
The following code will get the configuration from 192.168.1.1 and output it
to the screen (stdout).
.P
.RS
session open 192.168.1.1 cisco
.br
session enable san-fran
.br
set ConfigList [ ezget config primary ]
.br
session close
.br
puts $ConfigList
.RE
.SH "SEE ALSO"
\fBsession\fR(n), \fBezset\fR(n), \fBezdo\fR(n)
.SH "KEYWORDS"
ezset, password, banner, hostname, snmp

