'\"
'\" Copyright (c) 2000 Andreas Kupries
'\" All right reserved
'\"
'\" CVS: $Id$ ezset.n
'\"
.so man.macros
.TH "ezset" n 1.0 ezset "Easy Set Command"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
ezset \- Set a configuration parameter on a Cisco device.
.SH "SYNOPSIS"
package require \fBlibcisco\fR
.sp
\fBezset password\fR ?SessionId? \fIPwType\fR \fICurrentPw\fR \fINewPw\fR\fR
.sp
\fBezset banner\fR ?options? ?SessionId? \fIBanner\fR\fR
.sp
\fBezset hostname\fR ?SessionId? \fIHostname\fR\fR
.sp
\fBezset contact\fR ?SessionId? \fIContact\fR\fR
.sp
\fBezset location\fR ?SessionId? \fILocation\fR\fR
.sp
\fBezset community\fR ?options? ?SessionId? \fIStringType\fR \fICommunity\fR?\fI,Acl\fR? ... ?\fICommunity\fR?\fI,Acl\fR??\fR
.sp
.BE
.SH "DESCRIPTION"
The \fBezset\fR command is used to set configuration parameters on Cisco
devices.
.P
The first argument to \fBezset\fR specifies the configuration element to set
on the target device.  A list of valid elements and their associated options
is detailed below.
.sp
.sp
Note: Before making a call to \fBezset\fR, a session must first be opened
to the target device using the \fBsession open\fR command.
.P
.TP
\fBezset password\fR ?SessionId? \fIPwType\fR \fICurrentPw\fR \fINewPw\fR\fR
Sets the password on the target device.
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
\fIPwType\fR may be one of two options--\fBlogin\fR or \fBenable\fR.
The \fBlogin\fR option will set the local login password on all vty,
con, and aux lines if the target system is an IOS-based device.  If the
target system is running Catalyst Code, the local login password will be
set.  If the target device is a 1900, the "enable password level 1" will
be set to \fINewPw\fR.  The \fBenable\fR option will set the
"enable secret" password if the target system is an IOS-based device.  If
the device is running Catalyst Code, the local enable password will be set.
If the target device is a 1900, the "enable password level 15" will be set
to \fINewPw\fR.
.sp
.sp
\fICurrentPw\fR is the current password.  This will usually be the same
password that was used to either open the session or put it into enable
mode.
.sp
.sp
\fINewPw\fR is the new password to be set.
.sp
.sp
On success, \fBezset password\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBezset banner\fR ?options? ?SessionId? \fIBanner\fR\fR
Sets the login banner on the target system.
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
\fIBanner\fR is by default assumed to be a Tcl list.  Each element of the
list is a separte line of text.  The lines of text that make up the list
need not have leading or trailing newline characters as these will be
automatically added when the banner is set on the target system.
If the target system is an IOS-based device, this command will set
the "banner login".  If the target system is running Catalyst Code,
the "set banner motd" command will be issued.  If the target system
is a 1900, nothing will be set.
.sp
.sp
The following options are supported:
.sp
.sp
\fB-file\fR
.sp
\fB--\fR
.sp (end of options)
.sp
.sp
The \fB-file\fR option will cause \fIBanner\fR to be interpreted as a
fully-qualified path and filename instead of a Tcl list.  The file
should be a readable ASCII file.  The entire contents of the file will be
read in as a Tcl list and then applied as the banner message on the target
system.
.sp
.sp
On success, \fBezset banner\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBezset hostname\fR ?SessionId? \fIHostname\fR\fR
Sets the hostname on the target system.
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
\fIHostname\fR is the hostname to be set on the target system.  The hostname
may not exceed 20 characters.  If the target system is an an IOS-based
device, the "hostname" command will be issued.  If the target system is
running Catalyst Code, the "set prompt" and "set system name" commands will
be issued.  If the target system is a 1900, the "hostname" command will be
isssued from global configuration mode.
.sp
.sp
On success, \fBezset hostname\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBezset contact\fR ?SessionId? \fIContact\fR\fR
Sets the system contact (SNMP sysContact) on the target system.
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
\fIContact\fR is the contact name to be set on the target system.  The
contact name may not exceed 220 characters.
.sp
.sp
On success, \fBezset hostname\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBezset location\fR ?SessionId? \fILocation\fR\fR
Sets the system location (SNMP sysLocation) on the target system.
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
\fILocation\fR is the location to be set on the target system.  The
location may not exceed 220 characters.
.sp
.sp
On success, \fBezset hostname\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBezset community\fR ?options? ?SessionId? \fIStringType\fR \fICommunity\fR?\fI,Acl\fR? ... ?\fICommunity\fR?\fI,Acl\fR??\fR
Sets the SNMP community string on the target device.
.sp
.sp
The following options are supported:
.sp
.sp
\fB-clear\fR
.sp
\fB--\fR
.sp (end of options)
.sp
.sp
The \fB-clear\fR option will cause the existing community strings to be
cleared before the new string(s) is/are applied.  This option has no effect
on switches running Catalyst code.
.sp
.sp
\fISessionId\fR identifies the session upon which the command will be
issued.  If \fISessionId\fR is not specified, the command will be issued
on the last session to be opened.
.sp
.sp
\fIStringType\fR identifies the type of community string to be set.  Valid
options are "\fBro\fR" for read-only, and "\fBrw\fR" for read-write.
.sp
.sp
\fICommunity\fR is the community string to be set.  \fIAcl\fR is an
optional variable which may be used in conjunction with the community string.
If an \fIAcl\fR is specified, a comma '\fB,\fR' must delimit the community
string and the \fIAcl\fR with no spaces in between.  This also means that the
community string cannot have a comma as part of the string.  The \fIAcl\fR
number has a different effect on the device depending on what OS it is
running.  For devices running IOS, the \fIAcl\fR should correspond to
a valid access-list number.  The \fIAcl\fR will be used to limit
what stations may access the device using this community string.  If the
switch is a 1900 or running Catalyst code, the \fIAcl\fR will be silently
ignored.
.sp
.sp
Multiple \fICommunity\fR or \fICommunity,Acl\fR variables may be specified.
However, how multiple strings are handled is again dependent upon the
target system's OS.  If the target system is an IOS-based device, every
community string (and optionally ACL) specified will be applied.  If the
target device is running Catalyst Code, only the first community string
in the list will be set.  If the target device is a 1900, only the first
four community strings will be set.
.sp
.sp
On success, \fBezset community\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.P
.SH "EXAMPLE"
The following code will open a session to 192.168.1.1, put the device in
"enable" mode, set the hostname to "R1", and change the enable password
from "san-fran" to "newpass".  It will then close the session to the device.
.P
.RS
session open 192.168.1.1 cisco
.br
session enable san-fran
.br
ezset hostname "R1"
.br
ezset password enable san-fran newpass
.br
session close
.br
.RE
.SH "SEE ALSO"
\fBsession\fR(n), \fBezget\fR(n), \fBezdo\fR(n)
.SH "KEYWORDS"
ezset, password, banner, hostname, snmp

