'\"
'\" Copyright (c) 2000 Andreas Kupries
'\" All right reserved
'\"
'\" CVS: $Id$ sendCmd.n
'\"
.so man.macros
.TH "sendCmd" n 1.0 sendCmd "Send Command"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
sendCmd \- Send a command to be executed on a Cisco device.
.SH "SYNOPSIS"
package require \fBlibcisco\fR
.sp
\fBsendCmd exec\fR ?options? ?\fISessionId\fR? \fICmd\fR\fR
.sp
\fBsendCmd global\fR ?options? ?\fISessionId\fR? \fICmd\fR\fR
.sp
\fBsendCmd line\fR ?options? ?\fISessionId\fR? \fILine\fR \fICmd\fR\fR
.sp
\fBsendCmd interface\fR ?options? ?\fISessionId\fR? \fIInterface\fR \fICmd\fR\fR
.sp
.BE
.SH "DESCRIPTION"
The \fBsendCmd\fR command is used to send commands to be executed on a Cisco
device.  The following Cisco devices have been verified to work with
\fBsendCmd\fR:
.TP
*
Cisco 7500 Series Routers
.TP
*
Cisco 3600 Series Routers
.TP
*
Cisco 2600 Series Routers
.TP
*
Cisco 2500 Series Routers
.TP
*
Cisco 1600 Series Routers
.TP
*
Cisco AS5300 Universal Access Servers
.TP
*
Catalyst Lightstream ATM Switches
.TP
*
Catalyst 5000 Route Switch Modules
.TP
*
Catalyst 5000 LAN Emulation Modules
.TP
*
Catalyst 6000 LAN Emulation Modules
.TP
*
Catalyst 6000 Family Multilayer Switch Feature Cards
.TP
*
Catalyst 6000 Family Switches
.TP
*
Catalyst 5000/5500 Family Switches
.TP
*
Catalyst 3500 Series XL Switches
.TP
*
Catalyst 2900 Series XL Switches
.TP
*
Catalyst 1900 Series Switches
.P
The first argument to \fBsendCmd\fR specifies the type of command to send
to the target device.  A list of valid types and their associated options
is detailed below.
.sp
.sp
Note: Before making a call to \fBsendCmd\fR, a session must first be opened
to the target device using the \fBsession open\fR command.
.P
.TP
\fBsendCmd exec\fR ?options? ?\fISessionId\fR? \fICmd\fR\fR
Sends a command from an EXEC prompt.  For IOS based devices, this is used to
send commands from a "user" or "privileged" EXEC prompt.  For switches running
Catalyst Code, this is used to send commands from "normal" and "privileged"
mode.  The command will be issued from an EXEC prompt at the current enable
level.
.sp
.sp
\fICmd\fR is a command to be issued on the target device.  \fISessionId\fR
should be explicitly specified if multiple sessions have been opened.  If it
is not, \fICmd\fR will be sent to the last session to be opened.  The
following options are supported:
.sp
.sp
\fB-patlist\fR \fIPatList\fR
.sp
\fB-timeout\fR \fITimeout\fR {\fI[0-9]+\fR}
.sp
\fB--\fR (end of options)
.sp
.sp
\fIPatList\fR is a pattern-action list following the convention required
by the \fBexpect\fR command from the Expect extension to Tcl written by
Don Libes.  The \fBexpect\fR command is documented both on-line and in the
O'Reilly book, \fIExploring Expect\fR, by Don Libes.  If no \fIPatList\fR
is specified, only a minimal amount of error checking is performed.  If
\fIPatList\fR is set to the keyword \fBnofeedback\fR, then the expected
result from issuing \fICmd\fR is nothing.  In other words, after
\fICmd\fR is issued, the device is expected to immediately display the next
prompt with no feedback from the command.  This is the norm when entering
configuration commands on an IOS-based device.
.sp
.sp
Commands issued using \fBsendCmd exec\fR are expected to complete within
10 seconds by default.  Completion is determined by matching a pattern, either
a default pattern, or a pattern explicitly specified using the
\fB-patlist\fR option.  On high latency, heavily loaded, or unreliable
WAN links, 10 seconds may not be a sufficient amount of time.
The \fB-timeout\fR option may be used to specify a different
timeout value.
.sp
.sp
On success, \fBsendCmd exec\fR returns the result of the command.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBsendCmd global\fR ?options? ?\fISessionId\fR? \fICmd\fR\fR
Sends a command in global config mode.
.sp
.sp
\fICmd\fR is a command to be issued on the target device.  \fISessionId\fR
should be explicitly specified if multiple sessions have been opened.  If it
is not, \fICmd\fR will be sent to the last session to be opened.  The
following option is supported:
.sp
.sp
\fB-patlist\fR \fIPatList\fR
.sp
\fB-timeout\fR \fITimeout\fR {\fI[0-9]+\fR}
.sp
\fB--\fR (end of options)
.sp
.sp
\fIPatList\fR is a pattern-action list following the convention required
by the \fBexpect\fR command from the Expect extension to Tcl written by
Don Libes.  The \fBexpect\fR command is documented both on-line and in the
O'Reilly book, \fIExploring Expect\fR, by Don Libes.  If no \fIPatList\fR
is specified, only a minimal amount of error checking is performed.  If
\fIPatList\fR is the keyword \fBnofeedback\fR, then the expected
result from issuing \fICmd\fR is nothing.  In other words, after
\fICmd\fR is issued, the device is expected to immediately display the next
prompt with no feedback from the command.
.sp
.sp
Commands issued using \fBsendCmd global\fR are expected to complete within
10 seconds by default.  Completion is determined by matching a pattern, either
a default pattern, or a pattern explicitly specified using the
\fB-patlist\fR option.  On high latency, heavily loaded, or unreliable
WAN links, 10 seconds may not be a sufficient amount of time.  The
\fB-timeout\fR option may be used to specify a different timeout
value.
.sp
.sp
On success, \fBsendCmd global\fR returns the result of the command.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBsendCmd line\fR ?options? ?\fISessionId\fR? \fILine\fR \fICmd\fR\fR
Sends a command in line configuration mode.
.sp
.sp
\fILine\fR is the line or range of lines to be configured.  \fILine\fR is
in the format and syntax that would be expected by an IOS device to follow
the "line" command from global config mode (e.g. "vty 0 4", "con 0", "1 5").
\fICmd\fR is a command to be issued on the target device.  \fISessionId\fR
should be explicitly specified if multiple sessions have been opened.  If it
is not, \fICmd\fR will be sent to the last session to be opened.  The
following option is supported:
.sp
.sp
\fB-patlist\fR \fIPatList\fR
.sp
\fB-timeout\fR \fITimeout\fR {\fI[0-9]+\fR}
.sp
\fB--\fR (end of options)
.sp
.sp
\fIPatList\fR is a pattern-action list following the convention required
by the \fBexpect\fR command from the Expect extension to Tcl written by
Don Libes.  The \fBexpect\fR command is documented both on-line and in the
O'Reilly book, \fIExploring Expect\fR, by Don Libes.  If no \fIPatList\fR
is specified, only a minimal amount of error checking is performed.  If
\fIPatList\fR is the keyword \fBnofeedback\fR, then the expected
result from issuing \fICmd\fR is nothing.  In other words, after
\fICmd\fR is issued, the device is expected to immediately display the next
prompt with no feedback from the command.
.sp
.sp
Commands issued using \fBsendCmd line\fR are expected to complete within
10 seconds by default.  Completion is determined by matching a pattern, either
a default pattern, or a pattern explicitly specified using the
\fB-patlist\fR option.  On high latency, heavily loaded, or unreliable
WAN links, 10 seconds may not be a sufficient amount of time.  The
\fB-timeout\fR option may be used to specify a different timeout value.
.sp
.sp
On success, \fBsendCmd line\fR returns the result of the command.
On error, a short text message is returned beginning with the string "err".
.P
.TP
\fBsendCmd interface\fR ?options? ?\fISessionId\fR? \fIInterface\fR \fICmd\fR\fR
Sends a command in interface configuration mode.
.sp
.sp
\fIInterface\fR is the interface to be configured.  \fIInterface\fR is
in the format and syntax that would be expected by an IOS device to follow
the "interface" command from global config mode (e.g. "ethernet0",
"serial0/0").  \fICmd\fR is a command to be issued on the target device.
\fISessionId\fR should be explicitly specified if multiple sessions have been
opened.  If it is not, \fICmd\fR will be sent to the last session to be
opened.  The following option is supported:
.sp
.sp
\fB-patlist\fR \fIPatList\fR
.sp
\fB-timeout\fR \fITimeout\fR {\fI[0-9]+\fR}
.sp
\fB--\fR (end of options)
.sp
.sp
\fIPatList\fR is a pattern-action list following the convention required
by the \fBexpect\fR command from the Expect extension to Tcl written by
Don Libes.  The \fBexpect\fR command is documented both on-line and in the
O'Reilly book, \fIExploring Expect\fR, by Don Libes.  If no \fIPatList\fR
is specified, only a minimal amount of error checking is performed.  If
\fIPatList\fR is the keyword \fBnofeedback\fR, then the expected
result from issuing \fICmd\fR is nothing.  In other words, after
\fICmd\fR is issued, the device is expected to immediately display the next
prompt with no feedback from the command.
.sp
.sp
Commands issued using \fBsendCmd interface\fR are expected to complete within
10 seconds by default.  Completion is determined by matching a pattern, either
a default pattern, or a pattern explicitly specified using the
\fB-patlist\fR option.  On high latency, heavily loaded, or unreliable
WAN links, 10 seconds may not be a sufficient amount of time.  The
\fB-timeout\fR option may be used to specify a different timeout value.
.sp
.sp
On success, \fBsendCmd interface\fR returns the result of the command.
On error, a short text message is returned beginning with the string "err".
.P
.SH "EXAMPLE"
The following code will open a session to 192.168.1.1, put the device in
"enable" mode, save the output from a "show running-config" command to the
variable \fIResult\fR, and turn off logging to the console.  It will
then close the session to the device.
.P
.RS
session open 192.168.1.1 cisco
.br
session enable san-fran
.br
set Result [ sendCmd exec "show run" ]
.br
sendCmd global "no logging console"
.br
session close
.br
.RE
.SH "SEE ALSO"
\fBsession\fR(n)
.SH "KEYWORDS"
send, sendCmd, exec, global, line, interface

