'\"
'\" Copyright (c) 2000 Andreas Kupries
'\" All right reserved
'\"
'\" CVS: $Id$ session.n
'\"
.so man.macros
.TH "session" n 1.0 session "Session"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
session \- Control sessions with remote Cisco network devices.
.SH "SYNOPSIS"
package require \fBlibcisco\fR
.sp
\fBsession open\fR ?options? \fIHost\fR \fILinePw\fR ?\fIUsername\fR \fIUserPw\fR?\fR
.sp
\fBsession enable\fR ?options? ?\fISessionId\fR? \fIPwList\fR\fR
.sp
\fBsession module\fR ?options? ?\fISessionId\fR? \fIModule\fR ?\fILinePw\fR? ?\fIUsername\fR \fIUserPw\fR?\fR
.sp
\fBsession logger\fR ?\fISessionId\fR? \fILogText\fR\fR
.sp
\fBsession close\fR ?\fISessionId\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
The \fBsession\fR command performs one of several session operations.
.P
.TP
\fBsession open\fR ?options? \fIHost\fR \fILinePw\fR ?\fIUsername\fR \fIUserPw\fR?\fR
Opens a session with the device specified by \fIHost\fR.  Once the
session is established, a "password:" or "username:" prompt (not case
sensitive) is expected.  If a "password:" prompt is detected, the password
specified by \fILinePw\fR will be sent.  On the other hand, if a "username:"
prompt is detected, the username associated with \fIUsername\fR will be sent.
Thereafter, a "password:" prompt will be expected and upon detection, the
password specified by \fIUserPw\fR will be sent instead of \fILinePw\fR.  If
the attempted password fails, it will be retried up to 3 times or until
the remote device closes the connection, whichever comes first.  Supported
options are as follows:
.sp
.sp
\fB-type\fR \fIType\fR {\fItelnet\fR | \fIssh\fR}
.sp
\fB-os\fR \fIOs\fR {\fIauto\fR | \fIios\fR | \fIxdi\fR | \fI1900\fR}
.sp
\fB-retries\fR \fIRetries\fR {\fI[0-9]+\fR}
.sp
\fB-pwprompt\fR \fIPwPrompt\fR
.sp
\fB-userprompt\fR \fIUserPrompt\fR
.sp
\fB-logfile\fR \fIFilename\fR
.sp
\fB-logappend\fR \fIFilename\fR
.sp
\fB-verbose\fR
.sp
\fB-timeout\fR \fITimeout\fR {\fI[0-9]+\fR}
.sp
\fB-port\fR \fITcpPort\fR {\fI[0-9]+\fR}
.sp
\fB--\fR (end of options)
.sp
.sp
The type of session to be established may be explicitly set using the
\fB-type\fR option.  Valid values for \fIType\fR are \fItelnet\fR and
\fIssh\fR (future).  If no type is specified, it will default to
\fItelnet\fR.
.sp
.sp
The \fB-os\fR option is used to explicitly set the expected
operating system of the target device.  Valid options for \fIOs\fR are
\fIauto\fR, \fIios\fR, \fIxdi\fR (CatCode), and \fI1900\fR.  \fIOs\fR
defaults to \fIauto\fR.  If an operating system is explicilty specified, the
command will return an error if the detected OS is different from that
which is specified by the \fIOs\fR option.
.sp
.sp
The \fB-retries\fR option controls how many times a password will
be attempted during login before returning an error.  \fIRetries\fR
defaults to 3.
.sp
.sp
The \fB-pwprompt\fR option provides a means for overriding the
default expected password prompt of "password:".  If the target device has
been configured to use a custom prompt (e.g. "Enter your PASSCODE:")
by AAA or some other means, it will be necessary to specify that
prompt using this option.
.sp
.sp
In the same manner as \fB-pwprompt\fR, the \fB-userprompt\fR
may be used to override the default expected username prompt of "username:".
The \fIPwPrompt\fR and \fIUserPrompt\fR may be a simple string, or a
regular expression (note: the pattern matcher is not case sensitive).
.sp
.sp
If a \fIFilename\fR is specified with either the \fB-logfile\fR
or \fB-logappend\fR options, a log file will be generated for the
session.  All output from the session will be logged to \fIFilename\fR
until a call is made to \fBsession close\fR.  The \fB-logfile\fR
option will overwrite an existing \fIFilename\fR if it exists.  The
\fB-logappend\fR option will append to \fIFilename\fR if it already
exists.
.sp
.sp
The \fB-verbose\fR option is a boolean option--it takes no
arguments.  Session output is normally suppressed or logged to a file using
the \fB-logfile\fR and \fB-logappend\fR options.  If the
\fB-verbose\fR option is specified, output from the session will
be written to the stdout stream.  The stdout stream is typically your
console or xterm.
.sp
.sp
The \fBsession open\fR command is expected to complete within
30 seconds by default.  On high latency, heavily loaded, or unreliable
WAN links, 30 seconds may not be a sufficient amount of time.
The \fB-timeout\fR option may be used to specify a different
timeout value.
.sp
.sp
The \fB-port\fR option is used to override the default destination
TCP port number (telnet default: 23).  For instance, in order to login
through an access server (a.k.a. terminal concentrator, terminal server)
which is directly connected to a console port, a different destination
TCP port will most likely need to be specified (e.g. 2001).
.sp
.sp
On success, \fBsession open\fR returns a unique \fISessionId\fR.  The use
of the returned \fISessionId\fR is optional and needed only if multiple
sessions will be opened simultaneously within the same interpreter.  On error
a short text string is returned beginning with the string "err".
.sp
.P
.TP
\fBsession enable\fR ?options? ?\fISessionId\fR? \fIPwList\fR\fR
The \fBsession enable\fR command is used to put the session in
privileged (enable) mode.  If multiple sessions have been opened,
\fISessionId\fR should be explicitly specified; otherwise,
\fBsession enable\fR will operate on the last session to be opened.
\fIPwList\fR is a Tcl list of one or more passwords to be
attempted.  The following options are supported:
.sp
.sp
\fB-retries\fR \fIRetries\fR {\fI[0-9]+\fR}
.sp
\fB-pwprompt\fR \fIPwPrompt\fR
.sp
\fB-timeout\fR \fITimeout\fR {\fI[0-9]+\fR}
.sp
\fB--\fR (end of options)
.sp
.sp
The \fB-retries\fR option controls the number of times a password
in \fIPwList\fR will be attempted before moving to the next password in
\fIPwList\fR or returning an error if all passwords have been attempted.
The default number of attempts is 3.
.sp
.sp
The \fB-pwprompt\fR option provides a means for overriding the
default expected password prompt of "password:".  If the target device has
been configured to use a custom prompt (e.g. "Enter your PASSCODE:")
by AAA or some other means, it will be necessary to specify that
prompt using this option.  \fIPwPrompt\fR may be a simple string or a
regular expression (note: the pattern matcher is not case sensitive).
.sp
.sp
The \fBsession enable\fR command is expected to complete within
30 seconds by default.  On high latency, heavily loaded, or unreliable
WAN links, 30 seconds may not be a sufficient amount of time.
The \fB-timeout\fR option may be used to specify a different
timeout value.
.sp
.sp
On success \fBsession enable\fR returns 0.  On error, a short text
message is returned beginning with the string "err".
.P
.TP
\fBsession module\fR ?options? ?\fISessionId\fR? \fIModule\fR ?\fILinePw\fR? ?\fIUsername\fR \fIUserPw\fR?\fR
The \fBsession module\fR command will session to the module specified
by \fIModule\fR
\fI(this command is intended for devices running Catalyst Code only)\fR.
Once the session is established, a "password:"
or "username:" prompt (not case sensitive) is expected.  If a
"password:" prompt is detected, the password specified by \fILinePw\fR
will be sent.  On the other hand, if a "username:" prompt is detected,
the username associated with \fIUsername\fR will be sent.  Thereafter,
a "password:" prompt will be expected and upon detection, the
password specified by \fIUserPw\fR will be sent instead of \fILinePw\fR.
\fIUserPw\fR, \fIUsername\fR, and \fILinePw\fR are optional values.  If
they are left unspecified, the same values that were used to open the
session with the call to \fBsession open\fR will be used.  If the
attempted password fails, it will be retried up to 3 times or until
the remote device closes the connection, whichever comes first.
Supported options are as follows:
.sp
.sp
\fB-retries\fR \fIRetries\fR {\fI[0-9]+\fR}
.sp
\fB-pwprompt\fR \fIPwPrompt\fR
.sp
\fB-userprompt\fR \fIUserPrompt\fR
.sp
\fB-timeout\fR \fITimeout\fR {\fI[0-9]+\fR}
.sp
\fB--\fR (end of options)
.sp
.sp
The \fB-retries\fR option controls how many times a password will
be attempted during login before returning an error.  \fIRetries\fR
defaults to 3.
.sp
.sp
The \fB-pwprompt\fR option provides a means for overriding the
default expected password prompt of "password:".  If the target device has
been configured to use a custom prompt (e.g. "Enter your PASSCODE:")
by AAA or some other means, it will be necessary to specify that
prompt using this option.  \fIPwPrompt\fR may be a simple string or a
regular expression (note: the pattern matcher is not case sensitive).
.sp
.sp
In the same manner as \fB-pwprompt\fR, the \fB-userprompt\fR
may be used to override the default expected username prompt of "username:".
The \fIPwPrompt\fR and \fIUserPrompt\fR may be a simple string, or a
regular expression (note: the pattern matcher is not case sensitive).
.sp
.sp
The \fBsession module\fR command is expected to complete within
30 seconds by default.  On high latency, heavily loaded, or unreliable
WAN links, 30 seconds may not be a sufficient amount of time.
The \fB-timeout\fR option may be used to specify a different
timeout value.
.sp
.sp
On success \fBsession module\fR returns 0.  On error, a short text
message is returned beginning with the string "err".
.P
.TP
\fBsession logger\fR ?\fISessionId\fR? \fILogText\fR\fR
\fBsession logger\fR provides a means for updating a logfile that was
opened via the \fB-logfile\fR or \fB-logappend\fR options to the
\fBsession open\fR command.
\fILogText\fR is the string of text to be added to the logfile.
If no \fISessionId\fR is specified, \fILogText\fR will be
logged to the last session to be opened.  If no logfile was opened by
\fBsession open\fR, this command will return success but will
have no effect.
.sp
.sp
On success, \fBsession logger\fR returns 0.  On error, a short text
message is returned beginning with the string "err".
.P
.TP
\fBsession close\fR ?\fISessionId\fR?\fR
The \fBsession close\fR command will close a session that was opened
using the \fBsession open\fR command.  The command works by
repeatedly sending the string "exit" to the target device until an
end-of-file (EOF) is detected.  If multiple sessions have been opened,
the last session to be opened will be closed if no \fISessionId\fR is
specified.  Supported options are as follows:
.sp
.sp
\fB-retries\fR \fIRetries\fR {\fI[0-9]+\fR}
.sp
\fB-timeout\fR \fITimeout\fR {\fI[0-9]+\fR}
.sp
\fB--\fR (end of options)
.sp
.sp
The \fB-retries\fR option controls the maximum number of times the
"exit" command will be issued on the target device.   If an EOF has not
been detected after issuing "exit" \fIRetries\fR times, the session will
be terminated by sending a SIGHUP to the spawned process (telnet or ssh).
The default number of retries is 5.
.sp
.sp
The \fBsession close\fR command is expected to complete within
15 seconds by default.  On high latency, heavily loaded, or unreliable
WAN links, 15 seconds may not be a sufficient amount of time.
The \fB-timeout\fR option may be used to specify a different
timeout value.
.sp
.sp
On success, \fBsession close\fR returns 0.  On error, a short text
message is returned beginning with the string "err".
.SH "EXAMPLE"
The following code will open a telnet session to 192.168.1.1 logging in with
a password of "cisco".  It will then put the device in "enable" mode
using a password of "san-fran".  After issuing any number of commands
on the device (...), the session is closed.  For the sake of brevity and
simplicity, no error checking is performed.
.P
.RS
session open 192.168.1.1 cisco
.br
session enable san-fran
.br
(...)
.br
session close
.br
.RE
.SH "SEE ALSO"
\fBsendCmd\fR(n), \fBezset\fR(n), \fBezget\fR(n), \fBezdo\fR(n)
.SH "KEYWORDS"
session, open, enable, module, logger, close

