'\"
'\" Generated from ezdo.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "ezdo" n 1.3 ezdo "Easy Do Commands"
.BS
.SH NAME
ezdo \- execute common commands
.SH "SYNOPSIS"
package require \fBlibcisco\fR
.sp
\fBezdo savecfg\fR ?options?\fR
.sp
\fBezdo clearcntrs\fR \fR
.sp
\fBezdo debug\fR \fIArgs\fR\fR
.sp
\fBezdo undebug\fR \fIArgs\fR\fR
.sp
\fBezdo reload\fR ?options?\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBezdo\fR command is used to perform a specifc task on a Cisco
network device.  The "Easy" family of functions provide an OS layer of
abstraction for common commands.  The first argument to \fBezdo\fR
specifies the task to be performed on the target device.  A list of
valid tasks and their associated options is detailed below.
.PP
\fBNote:\fR Before making a call to \fBezdo\fR, a session must first be
opened to the target device using the \fBsession open\fR command.
.SH "COMMANDS"
.TP
\fBezdo savecfg\fR ?options?\fR
Saves the configuration in RAM to NVRAM.
.sp
The following options are supported:
.RS
.TP
\fB\--ifchanged\fR
The configuration will be saved only if a change has been made.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBezdo savecfg\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezdo clearcntrs\fR \fR
Clears all counters on the target system.
.sp
On success, \fBezdo clearcntrs\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezdo debug\fR \fIArgs\fR\fR
Enable debugging on the target device. (IOS only)
.sp
\fIArgs\fR is one or more arguments to be concatenated together and
evaluated on the target system as a debug command.
.sp
On success, \fBezdo debug\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezdo undebug\fR \fIArgs\fR\fR
Disable debugging on the target device. (IOS only)
.sp
\fIArgs\fR is one or more arguments to be concatenated together and
evaluated on the target system as an undebug command.
.sp
On success, \fBezdo undebug\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezdo reload\fR ?options?\fR
Reload/reset the target system.  If the target host is an IOS system and
its running-config is different from the startup-config, the config will
first be saved to NVRAM before resetting.
.sp
The following options are supported:
.RS
.TP
\fB\--nosave\fR
IOS only.  The configuration will NOT be saved if the running-config is
different from the startup-config.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBezdo reload\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.SH "EXAMPLE"
.PP
The following code will open a session to 192.168.1.1, put the device in
"enable" mode, enable ICMP debugging, clear the counters, and logout.
.PP
.nf
#!/bin/sh
# the next line restarts using the tclsh interpreter \ 
exec tclsh "$0" "$@"

package require libcisco
namespace import libcisco::*

session open 192.168.1.1 cisco
session enable san-fran
ezdo debug ip icmp
ezdo clearcntrs
session close
.fi
.SH "AUTHOR"
Andy Ziegelbein <\fImailto:aziegelb@users.sourceforge.net\fR>
.SH "SEE ALSO"
session(n), sendCmd(n), ezset(n), ezget(n)
.SH "KEYWORDS"
ezdo, clear, counters, save, config, debug, undebug
