'\"
'\" Generated from ezget.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "ezget" n 1.3 ezget "Easy Get Commands"
.BS
.SH NAME
ezget \- get common information
.SH "SYNOPSIS"
package require \fBlibcisco\fR
.sp
\fBezget config\fR \fIConfigType\fR\fR
.sp
\fBezget version\fR ?\fIvarNameArray\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBezget\fR command is used to get information from Cisco network
equipment.  The first argument to \fBezget\fR specifies the type of
information to get from the target device.  A list of valid information
elements and their associated options is detailed below.
.PP
\fBNote:\fR Before making a call to \fBezget\fR, a session must first
be opened to the target device using the \fBsession open\fR command.
.SH "COMMANDS"
.TP
\fBezget config\fR \fIConfigType\fR\fR
Get the configuration from the target device.
.sp
\fIConfigType\fR may be one of two options--\fBprimary\fR or
\fBsecondary\fR.  The \fBprimary\fR option will cause the command to
get the running-config from an IOS device, the complete config of a switch
running Catalyst code, and the complete configuration of a 1900.  The
\fBsecondary\fR option will cause the function to retrieve the
startup-config from an IOS device, the nondefault config from a switch
running Catalyst code, and nothing from a 1900.
.sp
On success, \fBezget config\fR returns the configuration.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezget version\fR ?\fIvarNameArray\fR?\fR
Get the operating system version from the target device.
.sp
\fIvarNameArray\fR is optional.  It is the name of a variable.
The variable should be an array.  The following elements will be set
if \fIvarNameArray\fR is specified:
.RS
.IP \(bu
\fBString\fR - represents the complete version string (same value
returned by the command)
.IP \(bu
\fBMajor\fR - the major version number
.IP \(bu
\fBMinor\fR - the minor version number
.IP \(bu
\fBMaint\fR - the maintenance release
.RE
.sp
On success, \fBezget version\fR returns the complete OS version.
On error, a short text message is returned beginning with the string "err".
.SH "EXAMPLE"
.PP
The following code will get the configuration from 192.168.1.1 and print it
to the screen (stdout).
.PP
.nf
#!/bin/sh
# the next line restarts using the tclsh interpreter \ 
exec tclsh "$0" "$@"

package require libcisco
namespace import libcisco::*

session open 192.168.1.1 cisco
session enable san-fran
set Config [ ezget config primary ]
session close
puts $Config
.fi
.SH "AUTHOR"
Andy Ziegelbein <\fImailto:aziegelb@users.sourceforge.net\fR>
.SH "SEE ALSO"
session(n), sendCmd(n), ezset(n), ezdo(n)
.SH "KEYWORDS"
ezget, configuration, running-config, startup-config, config
