'\"
'\" Generated from ezset.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "ezset" n 1.3 ezset "Easy Set Commands"
.BS
.SH NAME
ezset \- set common configuration parameters
.SH "SYNOPSIS"
package require \fBlibcisco\fR
.sp
\fBezset password\fR \fIPwType\fR \fICurrentPw\fR \fINewPw\fR\fR
.sp
\fBezset banner\fR ?options? \fIBanner\fR\fR
.sp
\fBezset hostname\fR \fIHostname\fR\fR
.sp
\fBezset contact\fR \fIContact\fR\fR
.sp
\fBezset location\fR \fILocation\fR\fR
.sp
\fBezset community\fR ?options? \fIStringType\fR \fICommunity\fR?\fI,Acl\fR? ... ?\fICommunity\fR?\fI,Acl\fR??\fR
.sp
\fBezset acl\fR ?options? \fIAclNum\fR \fIAclList\fR\fR
.sp
\fBezset permitlist\fR ?options? \fIPermitList\fR\fR
.sp
\fBezset ippermit\fR \fIOperator\fR \fIOperand\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBezset\fR command is used to set common configuration parameters
on Cisco network equipment.  The first argument to \fBezset\fR specifies
the configuration element to set on the target device.  A list of valid
elements and their associated options is detailed below.
.PP
\fBNote:\fR Before making a call to \fBezset\fR, a session must first
be opened to the target device using the \fBsession open\fR command.
.SH "COMMANDS"
.TP
\fBezset password\fR \fIPwType\fR \fICurrentPw\fR \fINewPw\fR\fR
Sets the password on the target device.
.sp
\fIPwType\fR may be one of two options--\fBlogin\fR or \fBenable\fR.
The \fBlogin\fR option will set the local login password on all vty,
con, and aux lines if the target system is an IOS-based device.  If the
target system is running Catalyst Code, the local login password will be
set.  If the target device is a 1900, the "enable password level 1" will
be set to \fINewPw\fR.  The \fBenable\fR option will set the
"enable secret" password if the target system is an IOS-based device.  If
the device is running Catalyst Code, the local enable password will be set.
If the target device is a 1900, the "enable password level 15" will be set
to \fINewPw\fR.
.sp
\fICurrentPw\fR is the current password.  This will usually be the same
password that was used to either open the session or put it into enable
mode.
.sp
\fINewPw\fR is the new password to be set.
.sp
On success, \fBezset password\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezset banner\fR ?options? \fIBanner\fR\fR
Sets the login banner on the target system.
.sp
\fIBanner\fR is by default assumed to be a Tcl list.  Each element of the
list is a separte line of text.  The lines of text that make up the list
need not have leading or trailing newline characters as these will be
automatically added when the banner is set on the target system.
If the target system is an IOS-based device, this command will set
the "banner login."  If the target system is running Catalyst Code,
the "set banner motd" command will be issued.  If the target system
is a 1900, nothing will be set.
.sp
The following options are supported:
.RS
.TP
\fB\--file\fR
This option will cause the \fIBanner\fR argument to be interpreted as a
filename instead of a Tcl list.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBezset banner\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezset hostname\fR \fIHostname\fR\fR
Sets the hostname on the target system.
.sp
\fIHostname\fR is the hostname to be set on the target system.  The hostname
may not exceed 20 characters.  If the target system is an an IOS-based
device, the "hostname" command will be issued.  If the target system is
running Catalyst Code, the "set prompt" and "set system name" commands will
be issued.  If the target system is a 1900, the "hostname" command will be
isssued from global configuration mode.
.sp
On success, \fBezset hostname\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezset contact\fR \fIContact\fR\fR
Sets the system contact (SNMP sysContact) on the target system.
.sp
\fIContact\fR is the contact name to be set on the target system.  The
contact name may not exceed 220 characters.
.sp
On success, \fBezset hostname\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezset location\fR \fILocation\fR\fR
Sets the system location (SNMP sysLocation) on the target system.
.sp
\fILocation\fR is the location to be set on the target system.  The
location may not exceed 220 characters.
.sp
On success, \fBezset hostname\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezset community\fR ?options? \fIStringType\fR \fICommunity\fR?\fI,Acl\fR? ... ?\fICommunity\fR?\fI,Acl\fR??\fR
Sets the SNMP community string on the target device.
.sp
\fIStringType\fR identifies the type of community string to be set.  Valid
options are "\fBro\fR" for read-only, and "\fBrw\fR" for read-write.
.sp
\fICommunity\fR is the community string to be set.  \fIAcl\fR is an
optional variable which may be used in conjunction with the community string.
If an \fIAcl\fR is specified, a comma '\fB,\fR' must delimit the community
string and the \fIAcl\fR with no spaces in between.  This also means that the
community string cannot have a comma as part of the string.  The \fIAcl\fR
number has a different effect on the device depending on what OS it is
running.  For devices running IOS, the \fIAcl\fR should correspond to
a valid access-list number.  The \fIAcl\fR will be used to limit
what stations may access the device using this community string.  If the
switch is a 1900 or running Catalyst code, the \fIAcl\fR will be silently
ignored.
.sp
Multiple \fICommunity\fR or \fICommunity,Acl\fR variables may be specified.
However, how multiple strings are handled is again dependent upon the
target system's OS.  If the target system is an IOS-based device, every
community string (and optionally ACL) specified will be applied.  If the
target device is running Catalyst Code, only the first community string
in the list will be set.  If the target device is a 1900, only the first
four community strings will be set.
.sp
The following options are supported:
.RS
.TP
\fB\--clear\fR
This option causes the existing community strings to be cleared
before the new string(s) is/are applied.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBezset community\fR returns 0.
On error, a short text message is returned beginning with the string "err".
.TP
\fBezset acl\fR ?options? \fIAclNum\fR \fIAclList\fR\fR
Sets an access control list (ACL).
.sp
\fBNote:\fR Before running this command against a device, consider
the effect that the new ACL will have on the device.  If the
ACL is being used for traffic filtering, route redistribution, or
whatever, be sure you have taken this into consideration as you could
lock yourself or others out of the device.
.sp
\fIAclNum\fR is an ACL number.
.sp
\fIAclList\fR is a Tcl list where each element is a separate ACL entry.
The expected format of the ACL entry is the same as what would be input into
an IOS device minus the leading "access-list x" string.  For example, a valid
entry for an IP standard ACL could be "permit 192.168.1.0 0.0.0.255".
.sp
The following options are supported:
.RS
.TP
\fB\--file\fR
This option will cause the \fIAclList\fR argument to be interpreted as a
filename instead of a Tcl list.
.TP
\fB\--ifdiff\fR
This option invokes a comparison of the new ACL and what is already
present in the config.  The new ACL will be applied only if it is either
not already present, or not the same.
.RE
.sp
On success, \fBezset acl\fR returns 0.
On error, a short text message is returned beginning with the string "err".
If the target device is running CatCode or the 1900 OS, the command will
always return success.
.TP
\fBezset permitlist\fR ?options? \fIPermitList\fR\fR
Sets a permit list on the target device.
.sp
\fBNote:\fR If the permit list is enabled on the target device for
telnet sessions, you \fBmust\fR call \fBezset ippermit disable telnet\fR
first to disable the permit list.  Failure to do so will disable all telnet
access into the switch.
.sp
\fIPermitList\fR is a Tcl list where each element is a separate
permit list entry.  The expected format of the permit list entry is the
same as what would be input into a CatCode device minus the leading
"set ip permit" string.  For example, a valid entry might be
"192.168.1.0 255.255.255.0".
.sp
The following options are supported:
.RS
.TP
\fB\--file\fR
This option will cause the \fIPermitList\fR argument to be interpreted as a
filename instead of a Tcl list.
.TP
\fB\--ifdiff\fR
This option invokes a comparison of the new permit list and what is already
present in the config.  The new list will be applied only if it is either
not already present, or not the same.
.RE
.sp
On success, \fBezset permitlist\fR returns 0.
On error, a short text message is returned beginning with the string "err".
If the target device is running CatCode or the 1900 OS, the command will
always return success.
.TP
\fBezset ippermit\fR \fIOperator\fR \fIOperand\fR\fR
Disables and enables the permit list on the target device.
.sp
\fBNote:\fR Be very careful when enabling the permit list as you do
not want to lock out your telnet session, or worse yet, all telnet access.
.sp
\fIOperator\fR is one of two values--\fBenable\fR or \fBdisable\fR.
.sp
\fIOperand\fR is one of three values--\fBall\fR, \fBtelnet\fR, or
\fBsnmp\fR.
.sp
On success, \fBezset ippermit\fR returns 0.
On error, a short text message is returned beginning with the string "err".
If the target device is running CatCode or the 1900 OS, the command will
always return success.
.SH "EXAMPLE"
.PP
The following code will open a session to 192.168.1.1, put the device in
"enable" mode, set the hostname to "R1", and change the enable password
from "san-fran" to "newpass".  It will then close the session to the device.
.PP
.nf
#!/bin/sh
# the next line restarts using the tclsh interpreter \ 
exec tclsh "$0" "$@"

package require libcisco
namespace import libcisco::*

session open 192.168.1.1 cisco
session enable san-fran
ezset hostname "R1"
ezset password enable san-fran newpass
session close
.fi
.SH "AUTHOR"
Andy Ziegelbein <\fImailto:aziegelb@users.sourceforge.net\fR>
.SH "SEE ALSO"
session(n), sendCmd(n), ezget(n), ezdo(n)
.SH "KEYWORDS"
ezset, password, banner, hostname, snmp
