'\"
'\" Generated from sendCmd.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "sendCmd" n 1.3 sendCmd "Send Command"
.BS
.SH NAME
sendCmd \- send and execute a command
.SH "SYNOPSIS"
package require \fBlibcisco\fR
.sp
\fBsendCmd exec\fR ?options? \fICmd\fR\fR
.sp
\fBsendCmd global\fR ?options? \fICmd\fR\fR
.sp
\fBsendCmd line\fR ?options? \fILine\fR \fICmd\fR\fR
.sp
\fBsendCmd interface\fR ?options? \fIInterface\fR \fICmd\fR\fR
.sp
\fBsendCmd acl\fR ?options? \fIProtocol\fR \fIType\fR \fIAcl\fR \fICmd\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBsendCmd\fR command is used to send commands to be executed on a
Cisco network device.  The first argument to \fBsendCmd\fR specifies the
type of command to send to the target device.  A list of valid types and
their associated options is detailed below.  The following devices have
been verified to work with \fBsendCmd\fR:
.IP \(bu
Cisco 7500 Series Routers
.IP \(bu
Cisco 3600 Series Routers
.IP \(bu
Cisco 2600 Series Routers
.IP \(bu
Cisco 2500 Series Routers
.IP \(bu
Cisco 1600 Series Routers
.IP \(bu
Cisco AS5300 Universal Access Servers
.IP \(bu
Catalyst Lightstream ATM Switches
.IP \(bu
Catalyst 5000 Route Switch Modules
.IP \(bu
Catalyst 5000 LAN Emulation Modules
.IP \(bu
Catalyst 6000 LAN Emulation Modules
.IP \(bu
Catalyst 6000 Family Multilayer Switch Feature Cards
.IP \(bu
Catalyst 6000 Family Switches
.IP \(bu
Catalyst 5000/5500 Family Switches
.IP \(bu
Catalyst 3500 Series XL Switches
.IP \(bu
Catalyst 2900 Series XL Switches
.IP \(bu
Catalyst 1900 Series Switches
.PP
\fBNote:\fR Before making a call to \fBsendCmd\fR, a session must
first be opened to the target device using the \fBsession open\fR command.
.SH "COMMANDS"
.TP
\fBsendCmd exec\fR ?options? \fICmd\fR\fR
Sends a command from an EXEC prompt.  For IOS based devices, this is used to
send commands from a "user" or "privileged" EXEC prompt.  For switches running
Catalyst Code, this is used to send commands from "normal" and "privileged"
mode.  The command will be issued from an EXEC prompt at the current enable
level.
.sp
\fICmd\fR is a command to be issued on the target device.
.sp
The following options are supported:
.RS
.TP
\fB\--patlist\fR \fIPatList\fR
\fIPatList\fR is a pattern-action list following the convention required
by the \fBexpect\fR command from the Expect extension to Tcl written by
Don Libes.  The \fBexpect\fR command is documented both on-line and in the
O'Reilly book, \fIExploring Expect\fR, by Don Libes.  If no \fIPatList\fR
is specified, only a minimal amount of error checking is performed.  If
\fIPatList\fR is set to the keyword \fBnofeedback\fR, then the expected
result from issuing \fICmd\fR is nothing.  In other words, after
\fICmd\fR is issued, the device is expected to immediately display the next
prompt with no feedback from the command.  This is the norm when entering
configuration commands on an IOS-based device.
.TP
\fB\--timeout\fR [0-9]+
By default, commands are expected to complete within 10 seconds.  This
option is used to override that default.  The timeout value is measured
in seconds.  The value supplied must be an integer.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBsendCmd exec\fR returns the result of the command.
On error, a short text message is returned beginning with the string "err".
.TP
\fBsendCmd global\fR ?options? \fICmd\fR\fR
Sends a command in global config mode.
.sp
\fICmd\fR is a command to be issued on the target device.
.sp
The following options are supported:
.RS
.TP
\fB\--patlist\fR \fIPatList\fR
\fIPatList\fR is a pattern-action list following the convention required
by the \fBexpect\fR command from the Expect extension to Tcl written by
Don Libes.  The \fBexpect\fR command is documented both on-line and in the
O'Reilly book, \fIExploring Expect\fR, by Don Libes.  If no \fIPatList\fR
is specified, only a minimal amount of error checking is performed.  If
\fIPatList\fR is set to the keyword \fBnofeedback\fR, then the expected
result from issuing \fICmd\fR is nothing.  In other words, after
\fICmd\fR is issued, the device is expected to immediately display the next
prompt with no feedback from the command.  This is the norm when entering
configuration commands on an IOS-based device.
.TP
\fB\--timeout\fR [0-9]+
By default, commands are expected to complete within 10 seconds.  This
option is used to override that default.  The timeout value is measured
in seconds.  The value supplied must be an integer.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBsendCmd global\fR returns the result of the command.
On error, a short text message is returned beginning with the string "err".
.TP
\fBsendCmd line\fR ?options? \fILine\fR \fICmd\fR\fR
Sends a command in line configuration mode.
.sp
\fILine\fR is the line or range of lines to be configured.  \fILine\fR is
in the format and syntax that would be expected by an IOS device to follow
the "line" command from global config mode (e.g. "vty 0 4", "con 0",
"1 5").  You may need to enclose \fILine\fR within quotes as it will almost
always have a space in the value (see example below).
.sp
\fICmd\fR is a command to be issued on the target device.
.sp
The following options are supported:
.RS
.TP
\fB\--patlist\fR \fIPatList\fR
\fIPatList\fR is a pattern-action list following the convention required
by the \fBexpect\fR command from the Expect extension to Tcl written by
Don Libes.  The \fBexpect\fR command is documented both on-line and in the
O'Reilly book, \fIExploring Expect\fR, by Don Libes.  If no \fIPatList\fR
is specified, only a minimal amount of error checking is performed.  If
\fIPatList\fR is set to the keyword \fBnofeedback\fR, then the expected
result from issuing \fICmd\fR is nothing.  In other words, after
\fICmd\fR is issued, the device is expected to immediately display the next
prompt with no feedback from the command.  This is the norm when entering
configuration commands on an IOS-based device.
.TP
\fB\--timeout\fR [0-9]+
By default, commands are expected to complete within 10 seconds.  This
option is used to override that default.  The timeout value is measured
in seconds.  The value supplied must be an integer.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBsendCmd line\fR returns the result of the command.
On error, a short text message is returned beginning with the string "err".
.TP
\fBsendCmd interface\fR ?options? \fIInterface\fR \fICmd\fR\fR
Sends a command in interface configuration mode.
.sp
\fIInterface\fR is the interface to be configured.  \fIInterface\fR is
in the format and syntax that would be expected by an IOS device to follow
the "interface" command from global config mode (e.g. "ethernet0",
"serial0/0").
.sp
\fICmd\fR is a command to be issued on the target device.
.sp
The following options are supported:
.RS
.TP
\fB\--patlist\fR \fIPatList\fR
\fIPatList\fR is a pattern-action list following the convention required
by the \fBexpect\fR command from the Expect extension to Tcl written by
Don Libes.  The \fBexpect\fR command is documented both on-line and in the
O'Reilly book, \fIExploring Expect\fR, by Don Libes.  If no \fIPatList\fR
is specified, only a minimal amount of error checking is performed.  If
\fIPatList\fR is set to the keyword \fBnofeedback\fR, then the expected
result from issuing \fICmd\fR is nothing.  In other words, after
\fICmd\fR is issued, the device is expected to immediately display the next
prompt with no feedback from the command.  This is the norm when entering
configuration commands on an IOS-based device.
.TP
\fB\--timeout\fR [0-9]+
By default, commands are expected to complete within 10 seconds.  This
option is used to override that default.  The timeout value is measured
in seconds.  The value supplied must be an integer.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBsendCmd interface\fR returns the result of the command.
On error, a short text message is returned beginning with the string "err".
.TP
\fBsendCmd acl\fR ?options? \fIProtocol\fR \fIType\fR \fIAcl\fR \fICmd\fR\fR
Sends a command in access-list configuration mode.
.sp
\fIProtocol\fR is the network layer protocol.  Valid options are "\fIip\fR" and "\fIipx\fR".
.sp
\fIType\fR is the type of access-list.  Valid options for \fIip\fR are "\fIstandard\fR" and "\fIextended\fR".  Valid options for \fIipx\fR are "\fIstandard\fR", "\fIextended\fR", and "\fIsap\fR".
.sp
\fICmd\fR is a command to be issued in access-list configuration mode.
.sp
The following options are supported:
.RS
.TP
\fB\--patlist\fR \fIPatList\fR
\fIPatList\fR is a pattern-action list following the convention required
by the \fBexpect\fR command from the Expect extension to Tcl written by
Don Libes.  The \fBexpect\fR command is documented both on-line and in the
O'Reilly book, \fIExploring Expect\fR, by Don Libes.  If no \fIPatList\fR
is specified, only a minimal amount of error checking is performed.  If
\fIPatList\fR is set to the keyword \fBnofeedback\fR, then the expected
result from issuing \fICmd\fR is nothing.  In other words, after
\fICmd\fR is issued, the device is expected to immediately display the next
prompt with no feedback from the command.  This is the norm when entering
configuration commands on an IOS-based device.
.TP
\fB\--timeout\fR [0-9]+
By default, commands are expected to complete within 10 seconds.  This
option is used to override that default.  The timeout value is measured
in seconds.  The value supplied must be an integer.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBsendCmd acl\fR returns the result of the command.
On error, a short text message is returned beginning with the string "err".
.SH "EXAMPLE"
.PP
The following code will open a session to 192.168.1.1, put the device in
"enable" mode, save the output from a "show version" command to the
variable \fBVersion\fR, turn off logging to the console, and set the console
line password to cisco.  It will then close the session to the device.
.PP
.nf
#!/bin/sh
# the next line restarts using the tclsh interpreter \ 
exec tclsh "$0" "$@"

package require libcisco
namespace import libcisco::*

session open 192.168.1.1 cisco
session enable san-fran
set Version [ sendCmd exec "show version" ]
sendCmd global "no logging console"
sendCmd line "con 0" "password cisco"
session close
.fi
.SH "AUTHOR"
Andy Ziegelbein <\fImailto:aziegelb@users.sourceforge.net\fR>
.SH "SEE ALSO"
session(n), ezdo(n), ezget(n), ezset(n)
.SH "KEYWORDS"
send, sendCmd, exec, global, line, interface
