'\"
'\" Generated from session.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "session" n 1.3 session "Session"
.BS
.SH NAME
session \- open/close/control sessions
.SH "SYNOPSIS"
package require \fBlibcisco\fR
.sp
\fBsession open\fR ?options? \fIHost\fR \fILinePw\fR ?\fITacUsername\fR \fITacUserPw\fR?\fR
.sp
\fBsession enable\fR ?options? \fIEnablePw\fR ?\fITacUsername\fR \fITacEnablePw\fR?\fR
.sp
\fBsession info\fR \fIInfoElement\fR\fR
.sp
\fBsession module\fR ?options? \fIModule\fR ?\fILinePw\fR? ?\fITacUsername\fR \fITacUserPw\fR?\fR
.sp
\fBsession logger\fR \fILogText\fR\fR
.sp
\fBsession close\fR ?options?\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBsession\fR command performs one of several session operations.
.SH "COMMANDS"
.TP
\fBsession open\fR ?options? \fIHost\fR \fILinePw\fR ?\fITacUsername\fR \fITacUserPw\fR?\fR
Opens a session (e.g. telnet/ssh) with the target device.
.sp
\fIHost\fR is the IP address or hostname of the target device.
.sp
\fILinePw\fR is the expected line password.
.sp
\fITacUsername\fR is optional.  It is the TACACS+/RADIUS username.
.sp
\fITacUserPw\fR is optional.  It is the TACACS/RADIUS login password.
.sp
Supported options are as follows:
.RS
.TP
\fB\--type\fR { telnet | ssh }
Specifies the type of session to establish.  Defaults to telnet.
.TP
\fB\--os\fR { auto | ios | xdi | 1900 }
Specifies the expected operating system of the target system.  An error
is returned if the detected OS does not match that which is specified by
this option, unless the option is auto.  The "xdi" option refers to
Catalyst code.  Defaults to auto.
.TP
\fB\--retries\fR [0-9]+
Specifies the maximum number of authentication attempts.  Defaults to 3.
.TP
\fB\--pwprompt\fR \fIPwPrompt\fR
This option is used to override the default expected "password:" prompt.
The value for \fIPwPrompt\fR can be a simple string, or a regular
expression.  If it is a regular expression, the '^' and '$' anchors
cannot be used.
.TP
\fB\--userprompt\fR \fIUserPrompt\fR
This option is used to override the default expected "username:" prompt.
The value for \fIUserPrompt\fR can be a simple string, or a regular
expression.  If it is a regular expression, the '^' and '$' anchors
cannot be used.
.TP
\fB\--logfile\fR \fIFilename\fR
This option enables logging to \fIFilename\fR.  If the file already exists
it will be overwritten.  Defaults to no log file.
.TP
\fB\--logappend\fR \fIFilename\fR
This option enables logging to \fIFilename\fR.  If the file already exists
it will be appended to.  Defaults to no log file.
.TP
\fB\--verbose\fR
Send output from the session to the stdout stream.
.TP
\fB\--timeout\fR [0-9]+
By default, \fBsession open\fR is expected to return within 30
seconds.  This option can be used to override the default.  The timeout
value is expressed in seconds.  The value supplied must be an integer.
.TP
\fB\--port\fR [0-9]+
This option is used to override the default destination port (e.g. TCP/23)
for the session.  Defaults to 23 for telnet, and 22 for ssh.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBsession open\fR returns an Expect spawn ID.  More than
likely, you will not need to use this ID unless you are very familiar with
Expect.  Even so, it is best to use the \fBlibcisco\fR routines like
\fBsendCmd\fR to interact with the session.  Failure to do so will result
in unpredictable results.  On error a short text string is returned
beginning with the string "err".
.TP
\fBsession enable\fR ?options? \fIEnablePw\fR ?\fITacUsername\fR \fITacEnablePw\fR?\fR
Place the device in privileged (enable) mode.
.sp
\fIEnablePw\fR is the enable password.
.sp
\fITacUsername\fR is optional.  It is the TACACS+/RADIUS username.
.sp
\fITacEnablePw\fR is optional.  It is the TACACS+/RADIUS enable password.
.sp
The following options are supported:
.RS
.TP
\fB\--retries\fR [0-9]+
Specifies the maximum number of authentication attempts.  Defaults to 3.
.TP
\fB\--pwprompt\fR \fIPwPrompt\fR
This option is used to override the default expected "password:" prompt.
The value for \fIPwPrompt\fR can be a simple string, or a regular
expression.  If it is a regular expression, the '^' and '$' anchors
cannot be used.
.TP
\fB\--userprompt\fR \fIUserPrompt\fR
This option is used to override the default expected "username:" prompt.
The value for \fIUserPrompt\fR can be a simple string, or a regular
expression.  If it is a regular expression, the '^' and '$' anchors
cannot be used.
.TP
\fB\--timeout\fR [0-9]+
By default, \fBsession enable\fR is expected to return within 30
seconds.  This option can be used to override the default.  The timeout
value is expressed in seconds.  The value supplied must be an integer.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success \fBsession enable\fR returns 0.  On error, a short text
message is returned beginning with the string "err".
.TP
\fBsession info\fR \fIInfoElement\fR\fR
Returns information about the session.  The type of information to be returned
is determined by the value of \fIInfoElement\fR.
.sp
\fIInfoElement\fR is the information element to be returned.  Valid options
for \fIInfoElement\fR are as follows:
.RS
.TP
\fBos\fR
Returns the operating system of the device.  One of three
values--\fIios\fR, \fIxdi\fR, or \fI1900\fR.
.TP
\fBmode\fR
Returns the current mode of the target system.  Valid return values
are \fIuser\fR for User EXEC mode, \fIenable\fR for Privileged
EXEC mode, \fIglobal\fR for global configuration mode, \fIline\fR
for line configuration mode, and \fIinterface\fR for interface
configuration mode.
.TP
\fBlastid\fR
Returns the last \fISessionId\fR that was opened by calling
\fBsession open\fR.
.TP
\fBcfgchange\fR
Returns 1 if the configuration of the target device was changed during
the current session.  Returns 0 if the configuration has not been changed
in the current session.
.RE
.sp
On success \fBsession info\fR returns the requested information element.
On error, a short text message is returned beginning with the string "err".
.TP
\fBsession module\fR ?options? \fIModule\fR ?\fILinePw\fR? ?\fITacUsername\fR \fITacUserPw\fR?\fR
Session to a module on the target device (e.g. LANE).
.sp
\fIModule\fR identifies the module number to be session'd to.
.sp
\fILinePw\fR is optional.  It is the line password on the target module.
.sp
\fITacUsername\fR is optional.  It is the TACACS+/RADIUS username to be
used during login.
.sp
\fITacUserPw\fR is optional.  It is the TACACS+/RADIUS password to be
used during login.
.sp
Supported options are as follows:
.RS
.TP
\fB\--retries\fR [0-9]+
Specifies the maximum number of authentication attempts.  Defaults to 3.
.TP
\fB\--pwprompt\fR \fIPwPrompt\fR
This option is used to override the default expected "password:" prompt.
The value for \fIPwPrompt\fR can be a simple string, or a regular
expression.  If it is a regular expression, the '^' and '$' anchors
cannot be used.
.TP
\fB\--userprompt\fR \fIUserPrompt\fR
This option is used to override the default expected "username:" prompt.
The value for \fIUserPrompt\fR can be a simple string, or a regular
expression.  If it is a regular expression, the '^' and '$' anchors
cannot be used.
.TP
\fB\--timeout\fR [0-9]+
By default, \fBsession enable\fR is expected to return within 30
seconds.  This option can be used to override the default.  The timeout
value is expressed in seconds.  The value supplied must be an integer.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success \fBsession module\fR returns 0.  On error, a short text
message is returned beginning with the string "err".
.TP
\fBsession logger\fR \fILogText\fR\fR
\fBsession logger\fR provides a means for updating a logfile that was
opened via the \fB-logfile\fR or \fB-logappend\fR options to the
\fBsession open\fR command.
.sp
\fILogText\fR is the string of text to be added to the logfile.
.sp
On success, \fBsession logger\fR returns 0.  On error, a short text
message is returned beginning with the string "err".
.TP
\fBsession close\fR ?options?\fR
Close an open session.
.sp
Supported options are as follows:
.RS
.TP
\fB\--retries\fR [0-9]+
Specifies the maximum number of attempts to exit.  Defaults to 5.
.TP
\fB\--timeout\fR [0-9]+
By default, \fBsession close\fR is expected to return within 15
seconds.  This option can be used to override the default.  The timeout
value is expressed in seconds.  The value supplied must be an integer.
.TP
\fB\---\fR
End of options.
.RE
.sp
On success, \fBsession close\fR returns 0.  On error, a short text
message is returned beginning with the string "err".
.SH "EXAMPLE"
The following code will open a telnet session to 192.168.1.1 logging in with
a password of "cisco".  It will then put the device in "enable" mode
using a password of "san-fran".  After issuing any number of commands
on the device (...), the session is closed.  For the sake of brevity and
simplicity, no error checking is performed.
.PP
.nf
#!/bin/sh
# the next line restarts using the tclsh interpreter \ 
exec tclsh "$0" "$@"

package require libcisco
namespace import libcisco::*

session open 192.168.1.1 cisco
session enable san-fran
(...)
session close
.fi
.SH "AUTHOR"
Andy Ziegelbein <\fImailto:aziegelb@users.sourceforge.net\fR>
.SH "SEE ALSO"
sendCmd(n), ezset(n), ezget(n), ezdo(n)
.SH "KEYWORDS"
session, open, enable, module, logger, close
