#!/bin/sh
# the next line restarts using the tclsh interpreter \
exec tclsh "$0" "$@"

# Tell the interpreter to load the libcisco package.  The interpreter will
# search through the directories and subdirectories of all directories listed
# in the auto_path variable for pkgIndex.tcl files.
package require libcisco

# The procedure names are all contained within a Tcl namespace of "libcisco"
# by default.  We can optionally import these procedures into the global
# namespace with the following command.  This basically means that the rest
# of the script can call the libcisco procedures without the leading
# ::libcisco:: in front of each procedure (e.g. "::libcisco::session" may now
# be called simply as "session".
namespace import ::libcisco::*

# This script expects that the following login information is passed in on
# the command-line as arguments.  Tcl stores these arguments in a the "argv"
# variable.
set Host     [ lindex $argv 0 ]
set LinePw   [ lindex $argv 1 ]
set EnablePw [ lindex $argv 2 ]

# This isn't absolutely necessary, but we'll use it in our next block of code.
# Tcl stores the name of the script being evaluated in a variable "argv0".
set ScriptName [ file tail $argv0 ]

# This doesn't have to be in here, but it's good coding practice to make sure
# we actually received the expected number of arguments passed in on the
# command-line.  Tcl stores the number of arguments passed in on the command-
# line, excluding the script name, in the "argc" variable.
if { $argc < 3 } {
    puts "Usage: $ScriptName {Host} {LinePw} {EnablePw}"
    exit 1
}

# The following is a list of standard logging settings.  This list will be
# used later in the script.
set LogSettingList {
    "no logging console"
    "logging buffer debug"
    "logging trap info"
    "logging facility local7"
    "logging 192.168.1.100"
}

# No error checking is performed on the following lines of code.  If the
# called procedure encounters an error, it will cause the script to exit
# with a return value of 1.  This is the default error-handling methodology.

# Open a session to the target host.
session open -logfile setLogging.log $Host $LinePw

# Put the session in privileged EXEC (enable) mode.
session enable $EnablePw

# Set the target system to use the logging standards defined above.
foreach LogSetting $LogSettingList {
    sendCmd global $LogSetting
}


# Close the session.  This will close the telnet session and cleanup all Tcl
# resources dedicated to the session.
session close
