//
//* \file debug.cc
//* \brief Debug channel definitions.
//
// This file is part of the libecc package.
// Copyright (C) 2002, by
//
// Carlo Wood, Run on IRC <carlo@alinoe.com>
// RSA-1024 0x624ACAD5 1997-01-26                    Sign & Encrypt
// Fingerprint16 = 32 EC A7 B6 AC DB 65 A6  F6 F6 55 DD 1C DC FF 61
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#include "sys.h"
#include "debug.h"

#if ECC_DEBUG

namespace libecc {
  namespace debug {
    namespace channels {	// namespace DEBUGCHANNELS

      namespace dc {
	libcw::debug::channel_ct ecc("ECC");
	libcw::debug::channel_ct polynomial("POLYNOMIAL");
	libcw::debug::channel_ct bitsetfind1("BITSETFIND1");
	libcw::debug::channel_ct bitsetshift("BITSETSHIFT");
      } // namespace dc

    } // namespace channels
  } // namespace debug
} // namespace libecc

#endif
