#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestFixture.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <libecc/bitset.h>
#include <inttypes.h>

template<unsigned int n>
  class OverLoadHook { };

class bitsetTest : public CppUnit::TestFixture {
  static size_t const digit_size = sizeof(libecc::bitset_digit_t);
  static size_t const digit_bits =
      ((digit_size == sizeof(uint8_t)) ? 8 :
      ((digit_size == sizeof(uint16_t)) ? 16 :
      ((digit_size == sizeof(uint32_t)) ? 32 :
      ((digit_size == sizeof(uint64_t)) ? 64 : 0))));

  static char const* const b7v3_str;
  static char const* const b7v3_bare;
  static char const* const b7v3_fit;
  static char const* const b7v3_excess;

  static char const* const b32v3_str;
  static char const* const b32v3_bare;
  static char const* const b32v3_excess1;
  static char const* const b32v3_excess2;
  static char const* const b32v3_excess3;
  static char const* const b32v3_excess4;

  static char const* const b32v32_str;
  static char const* const b32v32_excess1;
  static char const* const b32v32_excess2;
  static char const* const b32v32_excess3;

  static char const* const b39v32_str;
  static char const* const b39v32_bare;
  static char const* const b39v32_fit;
  static char const* const b39v32_excess1;
  static char const* const b39v32_excess2;

  static char const* const b64v63_str;
  static char const* const b64v63_excess1;
  static char const* const b64v63_excess2;

  static char const* const b64v64_str;
  static char const* const b64v64_excess;

  static char const* const b65v65_str;
  static char const* const b65v65_fit;
  static char const* const b65v65_excess;

  static char const* const b195v195_str;
  static char const* const b195v195_fit;

  static char const* const b205v195_str;
  static char const* const b205v195_bare;
  static char const* const b205v195_fit;

  static char const* const b205v205_str;
  static char const* const b205v205_fit;

  libecc::bitset<7> const b7v3;       //                                                                               0000101
  libecc::bitset<32> const b32v3;     //                                                      00000000000000000000000000000101
  libecc::bitset<32> const b32v32;    //                                                      11010010001111011010111000000101
  libecc::bitset<39> const b39v32;    //                                               000000011010010001111011010111000000101
  libecc::bitset<64> const b64v64;    //                      1111100010100000000100111100011101000010001111011010111000000101
  libecc::bitset<64> const b64v63;    //                      0100001000111101101011100000010111111000101000000001001111000111
  libecc::bitset<65> const b65v65;    //                     11111100010100000000100111100011101000010001111011010111000000101
  libecc::bitset<195> const b195v195; //           10111...0001111100010100000000100111100011101000010001111011010111000000101
  libecc::bitset<205> const b205v195; // 000000000010111...0001111100010100000000100111100011101000010001111011010111000000101
  libecc::bitset<205> const b205v205; // 110011100010111...0001111100010100000000100111100011101000010001111011010111000000101

  enum
  {
    eb7v3	=   7000,
    eb32v3	=  32001,
    eb32v32	=  32002,
    eb39v32	=  39003,
    eb64v64	=  64004,
    eb64v63	=  64005,
    eb65v65	=  65006,
    eb195v195	= 195007,
    eb205v195	= 205008,
    eb205v205	= 205009
  };

  // Accessors for b.
  libecc::bitset<7> const& get_b(OverLoadHook<eb7v3>) { return b7v3; }
  libecc::bitset<32> const& get_b(OverLoadHook<eb32v3>) { return b32v3; }
  libecc::bitset<32> const& get_b(OverLoadHook<eb32v32>) { return b32v32; }
  libecc::bitset<39> const& get_b(OverLoadHook<eb39v32>) { return b39v32; }
  libecc::bitset<64> const& get_b(OverLoadHook<eb64v64>) { return b64v64; }
  libecc::bitset<64> const& get_b(OverLoadHook<eb64v63>) { return b64v63; }
  libecc::bitset<65> const& get_b(OverLoadHook<eb65v65>) { return b65v65; }
  libecc::bitset<195> const& get_b(OverLoadHook<eb195v195>) { return b195v195; }
  libecc::bitset<205> const& get_b(OverLoadHook<eb205v195>) { return b205v195; }
  libecc::bitset<205> const& get_b(OverLoadHook<eb205v205>) { return b205v205; }

  static char const* const b_str[10];

  // 0110010110011010 = 659A
  // 0011001100111100 = 333C
  // -----------------------------
  // 0010000100011000 = 2118   AND
  // 0111011110111110 =        OR
  // 0101011010100110 =        XOR
  // -----------------------------
  // 1111010000001011 = F40B
  static char const* const x_str;
  static char const* const y_str;
  static char const* const z_str;
  static char const* const x_AND_y_13_str;
  static char const* const x_AND_y_32_str;
  static char const* const x_AND_y_45_str;
  static char const* const x_AND_y_64_str;
  static char const* const x_AND_y_77_str;
  static char const* const x_AND_y_96_str;
  static char const* const x_AND_y_109_str;
  static char const* const x_AND_y_128_str;

  libecc::bitset<13> const x13;
  libecc::bitset<13> const y13;
  libecc::bitset<13> const z13;
  libecc::bitset<32> const x32;
  libecc::bitset<32> const y32;
  libecc::bitset<32> const z32;
  libecc::bitset<45> const x45;
  libecc::bitset<45> const y45;
  libecc::bitset<45> const z45;
  libecc::bitset<64> const x64;
  libecc::bitset<64> const y64;
  libecc::bitset<64> const z64;
  libecc::bitset<77> const x77;
  libecc::bitset<77> const y77;
  libecc::bitset<77> const z77;
  libecc::bitset<96> const x96;
  libecc::bitset<96> const y96;
  libecc::bitset<96> const z96;
  libecc::bitset<109> const x109;
  libecc::bitset<109> const y109;
  libecc::bitset<109> const z109;
  libecc::bitset<128> const x128;
  libecc::bitset<128> const y128;
  libecc::bitset<128> const z128;

  // Accessors for x and y.
  libecc::bitset<13> const& get_x(OverLoadHook<13>) const { return x13; }
  libecc::bitset<13> const& get_y(OverLoadHook<13>) const { return y13; }
  libecc::bitset<13> const& get_z(OverLoadHook<13>) const { return z13; }
  libecc::bitset<32> const& get_x(OverLoadHook<32>) const { return x32; }
  libecc::bitset<32> const& get_y(OverLoadHook<32>) const { return y32; }
  libecc::bitset<32> const& get_z(OverLoadHook<32>) const { return z32; }
  libecc::bitset<45> const& get_x(OverLoadHook<45>) const { return x45; }
  libecc::bitset<45> const& get_y(OverLoadHook<45>) const { return y45; }
  libecc::bitset<45> const& get_z(OverLoadHook<45>) const { return z45; }
  libecc::bitset<64> const& get_x(OverLoadHook<64>) const { return x64; }
  libecc::bitset<64> const& get_y(OverLoadHook<64>) const { return y64; }
  libecc::bitset<64> const& get_z(OverLoadHook<64>) const { return z64; }
  libecc::bitset<77> const& get_x(OverLoadHook<77>) const { return x77; }
  libecc::bitset<77> const& get_y(OverLoadHook<77>) const { return y77; }
  libecc::bitset<77> const& get_z(OverLoadHook<77>) const { return z77; }
  libecc::bitset<96> const& get_x(OverLoadHook<96>) const { return x96; }
  libecc::bitset<96> const& get_y(OverLoadHook<96>) const { return y96; }
  libecc::bitset<96> const& get_z(OverLoadHook<96>) const { return z96; }
  libecc::bitset<109> const& get_x(OverLoadHook<109>) const { return x109; }
  libecc::bitset<109> const& get_y(OverLoadHook<109>) const { return y109; }
  libecc::bitset<109> const& get_z(OverLoadHook<109>) const { return z109; }
  libecc::bitset<128> const& get_x(OverLoadHook<128>) const { return x128; }
  libecc::bitset<128> const& get_y(OverLoadHook<128>) const { return y128; }
  libecc::bitset<128> const& get_z(OverLoadHook<128>) const { return z128; }

  libecc::bitset<13> const AND13;
  libecc::bitset<32> const AND32;
  libecc::bitset<45> const AND45;
  libecc::bitset<64> const AND64;
  libecc::bitset<77> const AND77;
  libecc::bitset<96> const AND96;
  libecc::bitset<109> const AND109;
  libecc::bitset<128> const AND128;

  // Accessors for AND.
  libecc::bitset<13> const& get_AND(OverLoadHook<13>) const { return AND13; }
  libecc::bitset<32> const& get_AND(OverLoadHook<32>) const { return AND32; }
  libecc::bitset<45> const& get_AND(OverLoadHook<45>) const { return AND45; }
  libecc::bitset<64> const& get_AND(OverLoadHook<64>) const { return AND64; }
  libecc::bitset<77> const& get_AND(OverLoadHook<77>) const { return AND77; }
  libecc::bitset<96> const& get_AND(OverLoadHook<96>) const { return AND96; }
  libecc::bitset<109> const& get_AND(OverLoadHook<109>) const { return AND109; }
  libecc::bitset<128> const& get_AND(OverLoadHook<128>) const { return AND128; }

public:
  bitsetTest(void) : b7v3(std::string(b7v3_str)),
                      b32v3(b32v3_str),
		      b32v32(b32v32_str),
                      b39v32(b39v32_str),
		      b64v64(b64v64_str),
		      b64v63(b64v63_str),
		      b65v65(b65v65_str),
		      b195v195(b195v195_str),
		      b205v195(b205v195_str),
		      b205v205(b205v205_str),
		      x13(x_str),
		      y13(y_str),
		      z13(z_str),
		      x32(x_str),
		      y32(y_str),
		      z32(z_str),
		      x45(x_str),
		      y45(y_str),
		      z45(z_str),
		      x64(x_str),
		      y64(y_str),
		      z64(z_str),
		      x77(x_str),
		      y77(y_str),
		      z77(z_str),
		      x96(x_str),
		      y96(y_str),
		      z96(z_str),
		      x109(x_str),
		      y109(y_str),
		      z109(z_str),
		      x128(x_str),
		      y128(y_str),
		      z128(z_str),
		      AND13(x_AND_y_13_str),
		      AND32(x_AND_y_32_str),
		      AND45(x_AND_y_45_str),
		      AND64(x_AND_y_64_str),
		      AND77(x_AND_y_77_str),
		      AND96(x_AND_y_96_str),
		      AND109(x_AND_y_109_str),
		      AND128(x_AND_y_128_str) { }

  void testConsts(void);
  template<unsigned int n>
    void testOutputLevel2(void);
  void testOutput(void);
  template<unsigned int n>
    void testConstructionLevel2(char const* str);
  void testConstruction(void);
  void testEquality(void);
  void testInequality(void);
  template<unsigned int n>
    void testAssignmentLevel2(void);
  void testAssignment(void);
  template<unsigned int n>
    void testCopyLevel2(void);
  void testCopy(void);
  template<unsigned int n, unsigned int n13, unsigned int n32, unsigned int n45, unsigned int n64, unsigned int n77, unsigned int n96, unsigned int n109, unsigned int n128>
    void testAndAssignLevel2(void);
  void testAndAssign(void);
  template<unsigned int n, unsigned int m>
    void testInvertLevel3(void);
  template<unsigned int n>
    void testInvertLevel2(void);
  void testInvert(void);
  template<unsigned int n, unsigned int m>
    void testOrAssignLevel3(void);
  template<unsigned int n>
    void testOrAssignLevel2(void);
  void testOrAssign(void);
  template<unsigned int n, unsigned int m>
    void testXorAssignLevel3(void);
  template<unsigned int n>
    void testXorAssignLevel2(void);
  void testXorAssign(void);
  template<unsigned int n, unsigned int m>
    void testAndAssignInvertLevel3(void);
  template<unsigned int n>
    void testAndAssignInvertLevel2(void);
  void testAndAssignInvert(void);
  template<unsigned int n, unsigned int m>
    void testOrAssignInvertLevel3(void);
  template<unsigned int n>
    void testOrAssignInvertLevel2(void);
  void testOrAssignInvert(void);
  template<unsigned int n, unsigned int m>
    void testXorAssignInvertLevel3(void);
  template<unsigned int n>
    void testXorAssignInvertLevel2(void);
  void testXorAssignInvert(void);
  void testAssignAnd(void);
  void testAssignOr(void);
  void testAssignXOr(void);
  void testAndAssignAnd(void);
  void testAndAssignOr(void);
  void testAndAssignXOr(void);
  void testOrAssignAnd(void);
  void testOrAssignOr(void);
  void testOrAssignXOr(void);
  void testXorAssignAnd(void);
  void testXorAssignOr(void);
  void testXorAssignXOr(void);
  void testAssignInvertAnd(void);
  void testAssignInvertOr(void);
  void testAssignInvertXOr(void);
  void testAndAssignInvertAnd(void);
  void testAndAssignInvertOr(void);
  void testAndAssignInvertXOr(void);
  void testOrAssignInvertAnd(void);
  void testOrAssignInvertOr(void);
  void testOrAssignInvertXOr(void);
  void testXorAssignInvertAnd(void);
  void testXorAssignInvertOr(void);
  void testXorAssignInvertXOr(void);
  void testAssignAndInvert(void);
  void testAssignOrInvert(void);
  void testAssignXOrInvert(void);
  void testAndAssignAndInvert(void);
  void testAndAssignOrInvert(void);
  void testAndAssignXOrInvert(void);
  void testOrAssignAndInvert(void);
  void testOrAssignOrInvert(void);
  void testOrAssignXOrInvert(void);
  void testXorAssignAndInvert(void);
  void testXorAssignOrInvert(void);
  void testXorAssignXOrInvert(void);
  void testAssignInvertAndInvert(void);
  void testAssignInvertOrInvert(void);
  void testAssignInvertXOrInvert(void);
  void testAndAssignInvertAndInvert(void);
  void testAndAssignInvertOrInvert(void);
  void testAndAssignInvertXOrInvert(void);
  void testOrAssignInvertAndInvert(void);
  void testOrAssignInvertOrInvert(void);
  void testOrAssignInvertXOrInvert(void);
  void testXorAssignInvertAndInvert(void);
  void testXorAssignInvertOrInvert(void);
  void testXorAssignInvertXOrInvert(void);
  template<unsigned int n, unsigned int b>
    void testBitOpsLevel3(void);
  template<unsigned int n>
    void testBitOpsLevel2(void);
  void testBitOps(void);
  template<unsigned int n>
    void testBitAllLevel2(void);
  void testBitAll(void);
  void testShift(void);
  void testRotate(void);
  template<unsigned int n>
    void testIteratorLevel2(void);
  void testIterator(void);

  CPPUNIT_TEST_SUITE( bitsetTest );

  CPPUNIT_TEST( testConsts );
  CPPUNIT_TEST( testOutput );
  CPPUNIT_TEST( testConstruction );
  CPPUNIT_TEST( testEquality );
  CPPUNIT_TEST( testInequality );
  CPPUNIT_TEST( testAssignment );
  CPPUNIT_TEST( testCopy );
  CPPUNIT_TEST( testAndAssign );
  CPPUNIT_TEST( testInvert );
  CPPUNIT_TEST( testOrAssign );
  CPPUNIT_TEST( testXorAssign );
  CPPUNIT_TEST( testAndAssignInvert );
  CPPUNIT_TEST( testOrAssignInvert );
  CPPUNIT_TEST( testXorAssignInvert );
  CPPUNIT_TEST( testAssignAnd );
  CPPUNIT_TEST( testAssignAndInvert );
  CPPUNIT_TEST( testAssignInvertAnd );
  CPPUNIT_TEST( testAssignInvertAndInvert );
  CPPUNIT_TEST( testAssignOr );
  CPPUNIT_TEST( testAssignOrInvert );
  CPPUNIT_TEST( testAssignInvertOr );
  CPPUNIT_TEST( testAssignInvertOrInvert );
  CPPUNIT_TEST( testAssignXOr );
  CPPUNIT_TEST( testAssignXOrInvert );
  CPPUNIT_TEST( testAssignInvertXOr );
  CPPUNIT_TEST( testAssignInvertXOrInvert );
  CPPUNIT_TEST( testAndAssignAnd );
  CPPUNIT_TEST( testAndAssignAndInvert );
  CPPUNIT_TEST( testAndAssignInvertAnd );
  CPPUNIT_TEST( testAndAssignInvertAndInvert );
  CPPUNIT_TEST( testAndAssignOr );
  CPPUNIT_TEST( testAndAssignOrInvert );
  CPPUNIT_TEST( testAndAssignInvertOr );
  CPPUNIT_TEST( testAndAssignInvertOrInvert );
  CPPUNIT_TEST( testAndAssignXOr );
  CPPUNIT_TEST( testAndAssignXOrInvert );
  CPPUNIT_TEST( testAndAssignInvertXOr );
  CPPUNIT_TEST( testAndAssignInvertXOrInvert );
  CPPUNIT_TEST( testOrAssignAnd );
  CPPUNIT_TEST( testOrAssignAndInvert );
  CPPUNIT_TEST( testOrAssignInvertAnd );
  CPPUNIT_TEST( testOrAssignInvertAndInvert );
  CPPUNIT_TEST( testOrAssignOr );
  CPPUNIT_TEST( testOrAssignOrInvert );
  CPPUNIT_TEST( testOrAssignInvertOr );
  CPPUNIT_TEST( testOrAssignInvertOrInvert );
  CPPUNIT_TEST( testOrAssignXOr );
  CPPUNIT_TEST( testOrAssignXOrInvert );
  CPPUNIT_TEST( testOrAssignInvertXOr );
  CPPUNIT_TEST( testOrAssignInvertXOrInvert );
  CPPUNIT_TEST( testXorAssignAnd );
  CPPUNIT_TEST( testXorAssignAndInvert );
  CPPUNIT_TEST( testXorAssignInvertAnd );
  CPPUNIT_TEST( testXorAssignInvertAndInvert );
  CPPUNIT_TEST( testXorAssignOr );
  CPPUNIT_TEST( testXorAssignOrInvert );
  CPPUNIT_TEST( testXorAssignInvertOr );
  CPPUNIT_TEST( testXorAssignInvertOrInvert );
  CPPUNIT_TEST( testXorAssignXOr );
  CPPUNIT_TEST( testXorAssignXOrInvert );
  CPPUNIT_TEST( testXorAssignInvertXOr );
  CPPUNIT_TEST( testXorAssignInvertXOrInvert );
  CPPUNIT_TEST( testBitOps );
  CPPUNIT_TEST( testBitAll );
  CPPUNIT_TEST( testShift );
  CPPUNIT_TEST( testRotate );
  CPPUNIT_TEST( testIterator );

  CPPUNIT_TEST_SUITE_END();
};
