#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

template<unsigned int n, unsigned int n13, unsigned int n32, unsigned int n45, unsigned int n64, unsigned int n77, unsigned int n96, unsigned int n109, unsigned int n128>
  void bitsetTest::testAndAssignLevel2(void)
  {
    libecc::bitset<n> res;
#ifndef FASTTEST
    res = get_x(OverLoadHook<n>());
    res &= y13;
    CPPUNIT_ASSERT( res == get_AND(OverLoadHook<n13>()) );
    CPPUNIT_ASSERT( (res.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    res = get_x(OverLoadHook<n>());
    res &= y32;
    CPPUNIT_ASSERT( res == get_AND(OverLoadHook<n32>()) );
    CPPUNIT_ASSERT( (res.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    res = get_x(OverLoadHook<n>());
    res &= y45;
    CPPUNIT_ASSERT( res == get_AND(OverLoadHook<n45>()) );
    CPPUNIT_ASSERT( (res.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    res = get_x(OverLoadHook<n>());
    res &= y64;
    CPPUNIT_ASSERT( res == get_AND(OverLoadHook<n64>()) );
    CPPUNIT_ASSERT( (res.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    res = get_x(OverLoadHook<n>());
    res &= y77;
    CPPUNIT_ASSERT( res == get_AND(OverLoadHook<n77>()) );
    CPPUNIT_ASSERT( (res.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    res = get_x(OverLoadHook<n>());
    res &= y96;
    CPPUNIT_ASSERT( res == get_AND(OverLoadHook<n96>()) );
    CPPUNIT_ASSERT( (res.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
#endif
    res = get_x(OverLoadHook<n>());
    res &= y109;
    CPPUNIT_ASSERT( res == get_AND(OverLoadHook<n109>()) );
    CPPUNIT_ASSERT( (res.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
#ifndef FASTTEST
    res = get_x(OverLoadHook<n>());
    res &= y128;
    CPPUNIT_ASSERT( res == get_AND(OverLoadHook<n128>()) );
    CPPUNIT_ASSERT( (res.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
#endif
  }

void bitsetTest::testAndAssign(void)
{
#ifndef FASTTEST
  testAndAssignLevel2<13, 13, 13, 13, 13, 13, 13, 13, 13>();
  testAndAssignLevel2<32, 13, 32, 32, 32, 32, 32, 32, 32>();
  testAndAssignLevel2<45, 13, 32, 45, 45, 45, 45, 45, 45>();
  testAndAssignLevel2<64, 13, 32, 45, 64, 64, 64, 64, 64>();
  testAndAssignLevel2<77, 13, 32, 45, 64, 77, 77, 77, 77>();
  testAndAssignLevel2<96, 13, 32, 45, 64, 77, 96, 96, 96>();
#endif
  testAndAssignLevel2<109, 13, 32, 45, 64, 77, 96, 109, 109>();
#ifndef FASTTEST
  testAndAssignLevel2<128, 13, 32, 45, 64, 77, 96, 109, 128>();
#endif
}
