#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

static char const* const sb_str[]  = {
  "1",						// bit 0
  "40",						// bit 6
  "1000",					// bit 12
  "40000",					// bit 18
  "1000000",					// bit 24
  "40000000",					// bit 30
  "1000000000",					// bit 36
  "40000000000",				// bit 42
  "1000000000000",				// bit 48
  "40000000000000",				// bit 54
  "1000000000000000",				// bit 60
  "40000000000000000",				// bit 66
  "1000000000000000000",			// bit 72
  "40000000000000000000",			// bit 78
  "1000000000000000000000",			// bit 84
  "40000000000000000000000",			// bit 90
  "1000000000000000000000000",			// bit 96
  "40000000000000000000000000",			// bit 102
  "1000000000000000000000000000",		// bit 108
  "40000000000000000000000000000",		// bit 114
  "1000000000000000000000000000000",		// bit 120
  "40000000000000000000000000000000",		// bit 126
};

template<unsigned int n, unsigned int b>
  void bitsetTest::testBitOpsLevel3(void)
  {
    if (b >= n)
      return;
    libecc::bitset<n> const zeros("0");
    libecc::bitset<n> const ones("FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF");
    libecc::bitset<n> const tmp1(sb_str[b / 6]);
    libecc::bitset<n> tmp2 = zeros;
    CPPUNIT_ASSERT( !tmp2.template test<b>() );
    CPPUNIT_ASSERT( !tmp2.any() );
    tmp2.template set<b>();
    CPPUNIT_ASSERT( tmp1 == tmp2 );
    CPPUNIT_ASSERT( tmp2.template test<b>() );
    CPPUNIT_ASSERT( tmp2.any() );
    tmp2.template clear<b>();
    CPPUNIT_ASSERT( tmp2 == zeros );
    tmp2.template flip<b>();
    CPPUNIT_ASSERT( tmp2 == tmp1 );
    tmp2.template flip<b>();
    CPPUNIT_ASSERT( tmp2 == zeros );
    tmp2 = ones;
    CPPUNIT_ASSERT( tmp2.template test<b>() );
    CPPUNIT_ASSERT( tmp2.any() );
    tmp2.template clear<b>();
    libecc::bitset<n> tmp3 = ones ^ tmp1;
    CPPUNIT_ASSERT( tmp2 == tmp3 );
    CPPUNIT_ASSERT( !tmp2.template test<b>() );
    CPPUNIT_ASSERT( tmp2.any() );
    tmp2.template set<b>();
    CPPUNIT_ASSERT( tmp2 == ones );
    tmp2.template flip<b>();
    CPPUNIT_ASSERT( tmp2 == tmp3 );
    tmp2.template flip<b>();
    CPPUNIT_ASSERT( tmp2 == ones );
  }

template<unsigned int n>
  void bitsetTest::testBitOpsLevel2(void)
  {
    libecc::bitset<n> const zeros("0");
    libecc::bitset<n> const ones("FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF");
    for (unsigned int b = 0; b < n; b += 6)
    {
      libecc::bitset<n> const tmp1(sb_str[b / 6]);
      libecc::bitset<n> tmp2 = zeros;
      CPPUNIT_ASSERT( !tmp2.test(b) );
      CPPUNIT_ASSERT( !tmp2.any() );
      tmp2.set(b);
      CPPUNIT_ASSERT( tmp1 == tmp2 );
      CPPUNIT_ASSERT( tmp2.test(b) );
      CPPUNIT_ASSERT( tmp2.any() );
      tmp2.clear(b);
      CPPUNIT_ASSERT( tmp2 == zeros );
      tmp2.flip(b);
      CPPUNIT_ASSERT( tmp2 == tmp1 );
      tmp2.flip(b);
      CPPUNIT_ASSERT( tmp2 == zeros );
      tmp2 = ones;
      CPPUNIT_ASSERT( tmp2.test(b) );
      CPPUNIT_ASSERT( tmp2.any() );
      tmp2.clear(b);
      libecc::bitset<n> tmp3 = ones ^ tmp1;
      CPPUNIT_ASSERT( tmp2 == tmp3 );
      CPPUNIT_ASSERT( !tmp2.test(b) );
      CPPUNIT_ASSERT( tmp2.any() );
      tmp2.set(b);
      CPPUNIT_ASSERT( tmp2 == ones );
      tmp2.flip(b);
      CPPUNIT_ASSERT( tmp2 == tmp3 );
      tmp2.flip(b);
      CPPUNIT_ASSERT( tmp2 == ones );
    }
#ifndef FASTTEST
    testBitOpsLevel3<n, 0>();
    testBitOpsLevel3<n, 6>();
    testBitOpsLevel3<n, 12>();
    testBitOpsLevel3<n, 18>();
    testBitOpsLevel3<n, 24>();
    testBitOpsLevel3<n, 30>();
    testBitOpsLevel3<n, 36>();
    testBitOpsLevel3<n, 42>();
    testBitOpsLevel3<n, 48>();
    testBitOpsLevel3<n, 54>();
    testBitOpsLevel3<n, 60>();
    testBitOpsLevel3<n, 66>();
    testBitOpsLevel3<n, 72>();
    testBitOpsLevel3<n, 78>();
    testBitOpsLevel3<n, 84>();
    testBitOpsLevel3<n, 90>();
    testBitOpsLevel3<n, 96>();
    testBitOpsLevel3<n, 102>();
#endif
    testBitOpsLevel3<n, 108>();
#ifndef FASTTEST
    testBitOpsLevel3<n, 114>();
    testBitOpsLevel3<n, 120>();
    testBitOpsLevel3<n, 126>();
#endif
  }

void bitsetTest::testBitOps(void)
{
#ifndef FASTTEST
  testBitOpsLevel2<13>();
  testBitOpsLevel2<32>();
  testBitOpsLevel2<45>();
  testBitOpsLevel2<64>();
  testBitOpsLevel2<77>();
  testBitOpsLevel2<96>();
#endif
  testBitOpsLevel2<109>();
#ifndef FASTTEST
  testBitOpsLevel2<128>();
#endif
}

