#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"
#include <algorithm>

// gcc 2.96 doesn't have std::ptr_fun
class do_toupper {
  public:
    int operator()(int const left) const { return std::toupper(left); }
};

template<unsigned int n>
  void bitsetTest::testConstructionLevel2(char const* str)
  {
    libecc::bitset<n / 1000> tmp(str);	// n / 1000 is the number of bits of get_b(OverLoadHook<n>()).
    std::ostringstream output;
    output << tmp;
    std::string s = output.str();
    std::transform(s.begin(), s.end(), s.begin(), do_toupper() /* ISO C++: std::ptr_fun<int, int>(std::toupper) */);
    CPPUNIT_ASSERT( std::string(b_str[n % 1000]) == s );
    CPPUNIT_ASSERT( get_b(OverLoadHook<n>()) == tmp );
    CPPUNIT_ASSERT( (tmp.digit(libecc::bitset<n / 1000>::digits - 1) & ~libecc::bitset<n / 1000>::valid_bits) == 0 );
  }

void bitsetTest::testConstruction(void)
{
  // Test equality as well as the constructor.
#ifndef FASTTEST
  testConstructionLevel2<eb7v3>(b7v3_bare);
  testConstructionLevel2<eb7v3>(b7v3_fit);
  testConstructionLevel2<eb7v3>(b7v3_excess);
  testConstructionLevel2<eb32v3>(b32v3_bare);
  testConstructionLevel2<eb32v3>(b32v3_excess1);
  testConstructionLevel2<eb32v3>(b32v3_excess2);
  testConstructionLevel2<eb32v3>(b32v3_excess3);
  testConstructionLevel2<eb32v3>(b32v3_excess4);
  testConstructionLevel2<eb32v32>(b32v32_excess1);
  testConstructionLevel2<eb32v32>(b32v32_excess2);
  testConstructionLevel2<eb32v32>(b32v32_excess3);
  testConstructionLevel2<eb39v32>(b39v32_bare);
  testConstructionLevel2<eb39v32>(b39v32_fit);
  testConstructionLevel2<eb39v32>(b39v32_excess1);
  testConstructionLevel2<eb39v32>(b39v32_excess2);
  testConstructionLevel2<eb64v64>(b64v64_excess);
  testConstructionLevel2<eb64v63>(b64v63_excess1);
  testConstructionLevel2<eb64v63>(b64v63_excess2);
  testConstructionLevel2<eb65v65>(b65v65_fit);
  testConstructionLevel2<eb65v65>(b65v65_excess);
#endif
  testConstructionLevel2<eb195v195>(b195v195_fit);
  testConstructionLevel2<eb205v195>(b205v195_bare);
  testConstructionLevel2<eb205v195>(b205v195_fit);
  testConstructionLevel2<eb205v205>(b205v205_fit);
}

