#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

template<unsigned int n>
  void bitsetTest::testCopyLevel2(void)
  {
#ifndef FASTTEST
    libecc::bitset<n> tmp7v3(b7v3);
    CPPUNIT_ASSERT( tmp7v3 == libecc::bitset<n>(b7v3_str) );
    CPPUNIT_ASSERT( (tmp7v3.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    libecc::bitset<n> tmp32v3(b32v3);
    CPPUNIT_ASSERT( tmp32v3 == libecc::bitset<n>(b32v3_str) );
    CPPUNIT_ASSERT( (tmp32v3.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    libecc::bitset<n> tmp32v32(b32v32);
    CPPUNIT_ASSERT( tmp32v32 == libecc::bitset<n>(b32v32_str) );
    CPPUNIT_ASSERT( (tmp32v32.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    libecc::bitset<n> tmp39v32(b39v32);
    CPPUNIT_ASSERT( tmp39v32 == libecc::bitset<n>(b39v32_str) );
    CPPUNIT_ASSERT( (tmp39v32.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    libecc::bitset<n> tmp64v64(b64v64);
    CPPUNIT_ASSERT( tmp64v64 == libecc::bitset<n>(b64v64_str) );
    CPPUNIT_ASSERT( (tmp64v64.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    libecc::bitset<n> tmp64v63(b64v63);
    CPPUNIT_ASSERT( tmp64v63 == libecc::bitset<n>(b64v63_str) );
    CPPUNIT_ASSERT( (tmp64v63.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    libecc::bitset<n> tmp65v65(b65v65);
    CPPUNIT_ASSERT( tmp65v65 == libecc::bitset<n>(b65v65_str) );
    CPPUNIT_ASSERT( (tmp65v65.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
#endif
    libecc::bitset<n> tmp195v195(b195v195);
    CPPUNIT_ASSERT( tmp195v195 == libecc::bitset<n>(b195v195_str) );
    CPPUNIT_ASSERT( (tmp195v195.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
#ifndef FASTTEST
    libecc::bitset<n> tmp205v195(b205v195);
    CPPUNIT_ASSERT( tmp205v195 == libecc::bitset<n>(b205v195_str) );
    CPPUNIT_ASSERT( (tmp205v195.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
    libecc::bitset<n> tmp205v205(b205v205);
    CPPUNIT_ASSERT( tmp205v205 == libecc::bitset<n>(b205v205_str) );
    CPPUNIT_ASSERT( (tmp205v205.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
#endif
  }

void bitsetTest::testCopy(void)
{
#ifndef FASTTEST
  testCopyLevel2<7>();
  testCopyLevel2<32>();
  testCopyLevel2<39>();
  testCopyLevel2<64>();
  testCopyLevel2<65>();
#endif
  testCopyLevel2<195>();
#ifndef FASTTEST
  testCopyLevel2<205>();
#endif
}
