#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

template<unsigned int n, unsigned int m>
  void bitsetTest::testInvertLevel3(void)
  {
    libecc::bitset<n> res;
    res = ~get_x(OverLoadHook<m>());
    libecc::bitset<n> tmp(get_x(OverLoadHook<m>()));
    for (unsigned int d = 0; d < libecc::bitset<n>::digits; ++d)
      tmp.rawdigit(d) ^= ~static_cast<libecc::bitset_digit_t>(0);
    tmp.rawdigit(libecc::bitset<n>::digits - 1) &= libecc::bitset<n>::valid_bits;
    CPPUNIT_ASSERT( res == tmp );
    CPPUNIT_ASSERT( (res.rawdigit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
  }

template<unsigned int n>
  void bitsetTest::testInvertLevel2(void)
  {
#ifndef FASTTEST
    testInvertLevel3<n, 13>();
    testInvertLevel3<n, 32>();
    testInvertLevel3<n, 45>();
    testInvertLevel3<n, 64>();
    testInvertLevel3<n, 77>();
    testInvertLevel3<n, 96>();
#endif
    testInvertLevel3<n, 109>();
#ifndef FASTTEST
    testInvertLevel3<n, 128>();
#endif
  }

void bitsetTest::testInvert(void)
{
#ifndef FASTTEST
  testInvertLevel2<13>();
  testInvertLevel2<32>();
  testInvertLevel2<45>();
  testInvertLevel2<64>();
  testInvertLevel2<77>();
  testInvertLevel2<96>();
#endif
  testInvertLevel2<109>();
#ifndef FASTTEST
  testInvertLevel2<128>();
#endif
}
