#include "sys.h"
#include "debug.h"
#include "bitsetTest.h"

template<unsigned int n, unsigned int m>
  void bitsetTest::testOrAssignLevel3(void)
  {
    libecc::bitset<n> tmp1;
    libecc::bitset<128> tmp2;
    libecc::bitset<n> tmp3;
    tmp1 = get_x(OverLoadHook<n>());
    tmp1 |= get_y(OverLoadHook<m>());
    tmp3 = ~get_x(OverLoadHook<n>());
    tmp2 = get_y(OverLoadHook<m>());
    tmp2 = ~tmp2;
    tmp3 &= tmp2;
    libecc::bitset<n> res;
    res = ~tmp3;
    CPPUNIT_ASSERT( tmp1 == res );
    CPPUNIT_ASSERT( (tmp1.digit(libecc::bitset<n>::digits - 1) & ~libecc::bitset<n>::valid_bits) == 0 );
  }

template<unsigned int n>
  void bitsetTest::testOrAssignLevel2(void)
  {
#ifndef FASTTEST
    testOrAssignLevel3<n, 13>();
    testOrAssignLevel3<n, 32>();
    testOrAssignLevel3<n, 45>();
    testOrAssignLevel3<n, 64>();
    testOrAssignLevel3<n, 77>();
    testOrAssignLevel3<n, 96>();
#endif
    testOrAssignLevel3<n, 109>();
#ifndef FASTTEST
    testOrAssignLevel3<n, 128>();
#endif
  }

void bitsetTest::testOrAssign(void)
{
#ifndef FASTTEST
  testOrAssignLevel2<13>();
  testOrAssignLevel2<32>();
  testOrAssignLevel2<45>();
  testOrAssignLevel2<64>();
  testOrAssignLevel2<77>();
  testOrAssignLevel2<96>();
#endif
  testOrAssignLevel2<109>();
#ifndef FASTTEST
  testOrAssignLevel2<128>();
#endif
}
